/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.aggregations.bucket.terms;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.LongHashSet;
import com.carrotsearch.hppc.LongSet;
import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongBitSet;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.ByteRunAutomaton;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.RegExp;
import org.easysearch.EasysearchParseException;
import org.easysearch.common.ParseField;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.common.io.stream.Writeable;
import org.easysearch.common.xcontent.ToXContent;
import org.easysearch.common.xcontent.ToXContentFragment;
import org.easysearch.common.xcontent.XContentBuilder;
import org.easysearch.common.xcontent.XContentParser;
import org.easysearch.search.DocValueFormat;

public class IncludeExclude
implements Writeable,
ToXContentFragment {
    public static final ParseField INCLUDE_FIELD = new ParseField("include", new String[0]);
    public static final ParseField EXCLUDE_FIELD = new ParseField("exclude", new String[0]);
    public static final ParseField PARTITION_FIELD = new ParseField("partition", new String[0]);
    public static final ParseField NUM_PARTITIONS_FIELD = new ParseField("num_partitions", new String[0]);
    private static final int HASH_PARTITIONING_SEED = 31;
    private final RegExp include;
    private final RegExp exclude;
    private final SortedSet<BytesRef> includeValues;
    private final SortedSet<BytesRef> excludeValues;
    private final int incZeroBasedPartition;
    private final int incNumPartitions;

    public static IncludeExclude merge(IncludeExclude include, IncludeExclude exclude) {
        String excludeMethod;
        if (include == null) {
            return exclude;
        }
        if (exclude == null) {
            return include;
        }
        if (include.isPartitionBased()) {
            throw new IllegalArgumentException("Cannot specify any excludes when using a partition-based include");
        }
        String includeMethod = include.isRegexBased() ? "regex" : "set";
        String string = excludeMethod = exclude.isRegexBased() ? "regex" : "set";
        if (!includeMethod.equals(excludeMethod)) {
            throw new IllegalArgumentException("Cannot mix a " + includeMethod + "-based include with a " + excludeMethod + "-based method");
        }
        if (include.isRegexBased()) {
            return new IncludeExclude(include.include, exclude.exclude);
        }
        return new IncludeExclude(include.includeValues, exclude.excludeValues);
    }

    public static IncludeExclude parseInclude(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.VALUE_STRING) {
            return new IncludeExclude(parser.text(), null);
        }
        if (token == XContentParser.Token.START_ARRAY) {
            return new IncludeExclude(new TreeSet<BytesRef>(IncludeExclude.parseArrayToSet(parser)), null);
        }
        if (token == XContentParser.Token.START_OBJECT) {
            String currentFieldName = null;
            Integer partition = null;
            Integer numPartitions = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (NUM_PARTITIONS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    numPartitions = parser.intValue();
                    continue;
                }
                if (PARTITION_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    partition = parser.intValue();
                    continue;
                }
                throw new EasysearchParseException("Unknown parameter in Include/Exclude clause: " + currentFieldName, new Object[0]);
            }
            if (partition == null) {
                throw new IllegalArgumentException("Missing [" + PARTITION_FIELD.getPreferredName() + "] parameter for partition-based include");
            }
            if (numPartitions == null) {
                throw new IllegalArgumentException("Missing [" + NUM_PARTITIONS_FIELD.getPreferredName() + "] parameter for partition-based include");
            }
            return new IncludeExclude(partition, numPartitions);
        }
        throw new IllegalArgumentException("Unrecognized token for an include [" + token + "]");
    }

    public static IncludeExclude parseExclude(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.VALUE_STRING) {
            return new IncludeExclude(null, parser.text());
        }
        if (token == XContentParser.Token.START_ARRAY) {
            return new IncludeExclude(null, new TreeSet<BytesRef>(IncludeExclude.parseArrayToSet(parser)));
        }
        throw new IllegalArgumentException("Unrecognized token for an exclude [" + token + "]");
    }

    public IncludeExclude(RegExp include, RegExp exclude) {
        if (include == null && exclude == null) {
            throw new IllegalArgumentException();
        }
        this.include = include;
        this.exclude = exclude;
        this.includeValues = null;
        this.excludeValues = null;
        this.incZeroBasedPartition = 0;
        this.incNumPartitions = 0;
    }

    public IncludeExclude(String include, String exclude) {
        this(include == null ? null : new RegExp(include), exclude == null ? null : new RegExp(exclude));
    }

    public IncludeExclude(SortedSet<BytesRef> includeValues, SortedSet<BytesRef> excludeValues) {
        if (includeValues == null && excludeValues == null) {
            throw new IllegalArgumentException();
        }
        this.include = null;
        this.exclude = null;
        this.incZeroBasedPartition = 0;
        this.incNumPartitions = 0;
        this.includeValues = includeValues;
        this.excludeValues = excludeValues;
    }

    public IncludeExclude(String[] includeValues, String[] excludeValues) {
        this(IncludeExclude.convertToBytesRefSet(includeValues), IncludeExclude.convertToBytesRefSet(excludeValues));
    }

    public IncludeExclude(double[] includeValues, double[] excludeValues) {
        this(IncludeExclude.convertToBytesRefSet(includeValues), IncludeExclude.convertToBytesRefSet(excludeValues));
    }

    public IncludeExclude(long[] includeValues, long[] excludeValues) {
        this(IncludeExclude.convertToBytesRefSet(includeValues), IncludeExclude.convertToBytesRefSet(excludeValues));
    }

    public IncludeExclude(int partition, int numPartitions) {
        if (partition < 0 || partition >= numPartitions) {
            throw new IllegalArgumentException("Partition must be >=0 and < numPartition which is " + numPartitions);
        }
        this.incZeroBasedPartition = partition;
        this.incNumPartitions = numPartitions;
        this.include = null;
        this.exclude = null;
        this.includeValues = null;
        this.excludeValues = null;
    }

    public IncludeExclude(StreamInput in) throws IOException {
        int i;
        int size;
        if (in.readBoolean()) {
            this.includeValues = null;
            this.excludeValues = null;
            this.incZeroBasedPartition = 0;
            this.incNumPartitions = 0;
            String includeString = in.readOptionalString();
            this.include = includeString == null ? null : new RegExp(includeString);
            String excludeString = in.readOptionalString();
            this.exclude = excludeString == null ? null : new RegExp(excludeString);
            return;
        }
        this.include = null;
        this.exclude = null;
        if (in.readBoolean()) {
            size = in.readVInt();
            this.includeValues = new TreeSet<BytesRef>();
            for (i = 0; i < size; ++i) {
                this.includeValues.add(in.readBytesRef());
            }
        } else {
            this.includeValues = null;
        }
        if (in.readBoolean()) {
            size = in.readVInt();
            this.excludeValues = new TreeSet<BytesRef>();
            for (i = 0; i < size; ++i) {
                this.excludeValues.add(in.readBytesRef());
            }
        } else {
            this.excludeValues = null;
        }
        this.incNumPartitions = in.readVInt();
        this.incZeroBasedPartition = in.readVInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        boolean regexBased = this.isRegexBased();
        out.writeBoolean(regexBased);
        if (regexBased) {
            out.writeOptionalString(this.include == null ? null : this.include.getOriginalString());
            out.writeOptionalString(this.exclude == null ? null : this.exclude.getOriginalString());
        } else {
            boolean hasIncludes = this.includeValues != null;
            out.writeBoolean(hasIncludes);
            if (hasIncludes) {
                out.writeVInt(this.includeValues.size());
                for (BytesRef value : this.includeValues) {
                    out.writeBytesRef(value);
                }
            }
            boolean hasExcludes = this.excludeValues != null;
            out.writeBoolean(hasExcludes);
            if (hasExcludes) {
                out.writeVInt(this.excludeValues.size());
                for (BytesRef value : this.excludeValues) {
                    out.writeBytesRef(value);
                }
            }
            out.writeVInt(this.incNumPartitions);
            out.writeVInt(this.incZeroBasedPartition);
        }
    }

    private static SortedSet<BytesRef> convertToBytesRefSet(String[] values) {
        TreeSet<BytesRef> returnSet = null;
        if (values != null) {
            returnSet = new TreeSet<BytesRef>();
            for (String value : values) {
                returnSet.add(new BytesRef((CharSequence)value));
            }
        }
        return returnSet;
    }

    private static SortedSet<BytesRef> convertToBytesRefSet(double[] values) {
        TreeSet<BytesRef> returnSet = null;
        if (values != null) {
            returnSet = new TreeSet<BytesRef>();
            for (double value : values) {
                returnSet.add(new BytesRef((CharSequence)String.valueOf(value)));
            }
        }
        return returnSet;
    }

    private static SortedSet<BytesRef> convertToBytesRefSet(long[] values) {
        TreeSet<BytesRef> returnSet = null;
        if (values != null) {
            returnSet = new TreeSet<BytesRef>();
            for (long value : values) {
                returnSet.add(new BytesRef((CharSequence)String.valueOf(value)));
            }
        }
        return returnSet;
    }

    private static Set<BytesRef> parseArrayToSet(XContentParser parser) throws IOException {
        HashSet<BytesRef> set = new HashSet<BytesRef>();
        if (parser.currentToken() != XContentParser.Token.START_ARRAY) {
            throw new EasysearchParseException("Missing start of array in include/exclude clause", new Object[0]);
        }
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            if (!parser.currentToken().isValue()) {
                throw new EasysearchParseException("Array elements in include/exclude clauses should be string values", new Object[0]);
            }
            set.add(new BytesRef((CharSequence)parser.text()));
        }
        return set;
    }

    public boolean isRegexBased() {
        return this.include != null || this.exclude != null;
    }

    public boolean isPartitionBased() {
        return this.incNumPartitions > 0;
    }

    private Automaton toAutomaton() {
        Automaton a = null;
        a = this.include != null ? this.include.toAutomaton() : (this.includeValues != null ? Automata.makeStringUnion(this.includeValues) : Automata.makeAnyString());
        if (this.exclude != null) {
            a = Operations.minus((Automaton)a, (Automaton)this.exclude.toAutomaton(), (int)10000);
        } else if (this.excludeValues != null) {
            a = Operations.minus((Automaton)a, (Automaton)Automata.makeStringUnion(this.excludeValues), (int)10000);
        }
        return a;
    }

    public StringFilter convertToStringFilter(DocValueFormat format) {
        if (this.isRegexBased()) {
            return new AutomatonBackedStringFilter(this.toAutomaton());
        }
        if (this.isPartitionBased()) {
            return new PartitionedStringFilter();
        }
        return new TermListBackedStringFilter(IncludeExclude.parseForDocValues(this.includeValues, format), IncludeExclude.parseForDocValues(this.excludeValues, format));
    }

    private static SortedSet<BytesRef> parseForDocValues(SortedSet<BytesRef> endUserFormattedValues, DocValueFormat format) {
        SortedSet<BytesRef> result = endUserFormattedValues;
        if (endUserFormattedValues != null && format != DocValueFormat.RAW) {
            result = new TreeSet<BytesRef>();
            for (BytesRef formattedVal : endUserFormattedValues) {
                result.add(format.parseBytesRef(formattedVal.utf8ToString()));
            }
        }
        return result;
    }

    public OrdinalsFilter convertToOrdinalsFilter(DocValueFormat format) {
        if (this.isRegexBased()) {
            return new AutomatonBackedOrdinalsFilter(this.toAutomaton());
        }
        if (this.isPartitionBased()) {
            return new PartitionedOrdinalsFilter();
        }
        return new TermListBackedOrdinalsFilter(IncludeExclude.parseForDocValues(this.includeValues, format), IncludeExclude.parseForDocValues(this.excludeValues, format));
    }

    public LongFilter convertToLongFilter(DocValueFormat format) {
        if (this.isPartitionBased()) {
            return new PartitionedLongFilter();
        }
        int numValids = this.includeValues == null ? 0 : this.includeValues.size();
        int numInvalids = this.excludeValues == null ? 0 : this.excludeValues.size();
        SetBackedLongFilter result = new SetBackedLongFilter(numValids, numInvalids);
        if (this.includeValues != null) {
            for (BytesRef val : this.includeValues) {
                result.addAccept(format.parseLong(val.utf8ToString(), false, null));
            }
        }
        if (this.excludeValues != null) {
            for (BytesRef val : this.excludeValues) {
                result.addReject(format.parseLong(val.utf8ToString(), false, null));
            }
        }
        return result;
    }

    public LongFilter convertToDoubleFilter() {
        double dval;
        if (this.isPartitionBased()) {
            return new PartitionedLongFilter();
        }
        int numValids = this.includeValues == null ? 0 : this.includeValues.size();
        int numInvalids = this.excludeValues == null ? 0 : this.excludeValues.size();
        SetBackedLongFilter result = new SetBackedLongFilter(numValids, numInvalids);
        if (this.includeValues != null) {
            for (BytesRef val : this.includeValues) {
                dval = Double.parseDouble(val.utf8ToString());
                result.addAccept(NumericUtils.doubleToSortableLong((double)dval));
            }
        }
        if (this.excludeValues != null) {
            for (BytesRef val : this.excludeValues) {
                dval = Double.parseDouble(val.utf8ToString());
                result.addReject(NumericUtils.doubleToSortableLong((double)dval));
            }
        }
        return result;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.include != null) {
            builder.field(INCLUDE_FIELD.getPreferredName(), this.include.getOriginalString());
        } else if (this.includeValues != null) {
            builder.startArray(INCLUDE_FIELD.getPreferredName());
            for (BytesRef value : this.includeValues) {
                builder.value(value.utf8ToString());
            }
            builder.endArray();
        } else if (this.isPartitionBased()) {
            builder.startObject(INCLUDE_FIELD.getPreferredName());
            builder.field(PARTITION_FIELD.getPreferredName(), this.incZeroBasedPartition);
            builder.field(NUM_PARTITIONS_FIELD.getPreferredName(), this.incNumPartitions);
            builder.endObject();
        }
        if (this.exclude != null) {
            builder.field(EXCLUDE_FIELD.getPreferredName(), this.exclude.getOriginalString());
        } else if (this.excludeValues != null) {
            builder.startArray(EXCLUDE_FIELD.getPreferredName());
            for (BytesRef value : this.excludeValues) {
                builder.value(value.utf8ToString());
            }
            builder.endArray();
        }
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.include == null ? null : this.include.getOriginalString(), this.exclude == null ? null : this.exclude.getOriginalString(), this.includeValues, this.excludeValues, this.incZeroBasedPartition, this.incNumPartitions);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IncludeExclude other = (IncludeExclude)obj;
        return Objects.equals(this.include == null ? null : this.include.getOriginalString(), other.include == null ? null : other.include.getOriginalString()) && Objects.equals(this.exclude == null ? null : this.exclude.getOriginalString(), other.exclude == null ? null : other.exclude.getOriginalString()) && Objects.equals(this.includeValues, other.includeValues) && Objects.equals(this.excludeValues, other.excludeValues) && Objects.equals(this.incZeroBasedPartition, other.incZeroBasedPartition) && Objects.equals(this.incNumPartitions, other.incNumPartitions);
    }

    static class AutomatonBackedStringFilter
    extends StringFilter {
        private final ByteRunAutomaton runAutomaton;

        private AutomatonBackedStringFilter(Automaton automaton) {
            this.runAutomaton = new ByteRunAutomaton(automaton);
        }

        @Override
        public boolean accept(BytesRef value) {
            return this.runAutomaton.run(value.bytes, value.offset, value.length);
        }
    }

    class PartitionedStringFilter
    extends StringFilter {
        PartitionedStringFilter() {
        }

        @Override
        public boolean accept(BytesRef value) {
            return Math.floorMod(StringHelper.murmurhash3_x86_32((BytesRef)value, (int)31), IncludeExclude.this.incNumPartitions) == IncludeExclude.this.incZeroBasedPartition;
        }
    }

    static class TermListBackedStringFilter
    extends StringFilter {
        private final Set<BytesRef> valids;
        private final Set<BytesRef> invalids;

        TermListBackedStringFilter(Set<BytesRef> includeValues, Set<BytesRef> excludeValues) {
            this.valids = includeValues;
            this.invalids = excludeValues;
        }

        @Override
        public boolean accept(BytesRef value) {
            return !(this.valids != null && !this.valids.contains(value) || this.invalids != null && this.invalids.contains(value));
        }
    }

    static class AutomatonBackedOrdinalsFilter
    extends OrdinalsFilter {
        private final CompiledAutomaton compiled;

        private AutomatonBackedOrdinalsFilter(Automaton automaton) {
            this.compiled = new CompiledAutomaton(automaton);
        }

        @Override
        public LongBitSet acceptedGlobalOrdinals(SortedSetDocValues globalOrdinals) throws IOException {
            LongBitSet acceptedGlobalOrdinals = new LongBitSet(globalOrdinals.getValueCount());
            DocValuesTerms globalTerms = new DocValuesTerms(globalOrdinals);
            TermsEnum globalTermsEnum = this.compiled.getTermsEnum((Terms)globalTerms);
            BytesRef term = globalTermsEnum.next();
            while (term != null) {
                acceptedGlobalOrdinals.set(globalTermsEnum.ord());
                term = globalTermsEnum.next();
            }
            return acceptedGlobalOrdinals;
        }
    }

    class PartitionedOrdinalsFilter
    extends OrdinalsFilter {
        PartitionedOrdinalsFilter() {
        }

        @Override
        public LongBitSet acceptedGlobalOrdinals(SortedSetDocValues globalOrdinals) throws IOException {
            long numOrds = globalOrdinals.getValueCount();
            LongBitSet acceptedGlobalOrdinals = new LongBitSet(numOrds);
            TermsEnum termEnum = globalOrdinals.termsEnum();
            BytesRef term = termEnum.next();
            while (term != null) {
                if (Math.floorMod(StringHelper.murmurhash3_x86_32((BytesRef)term, (int)31), IncludeExclude.this.incNumPartitions) == IncludeExclude.this.incZeroBasedPartition) {
                    acceptedGlobalOrdinals.set(termEnum.ord());
                }
                term = termEnum.next();
            }
            return acceptedGlobalOrdinals;
        }
    }

    static class TermListBackedOrdinalsFilter
    extends OrdinalsFilter {
        private final SortedSet<BytesRef> includeValues;
        private final SortedSet<BytesRef> excludeValues;

        TermListBackedOrdinalsFilter(SortedSet<BytesRef> includeValues, SortedSet<BytesRef> excludeValues) {
            this.includeValues = includeValues;
            this.excludeValues = excludeValues;
        }

        @Override
        public LongBitSet acceptedGlobalOrdinals(SortedSetDocValues globalOrdinals) throws IOException {
            long ord;
            LongBitSet acceptedGlobalOrdinals = new LongBitSet(globalOrdinals.getValueCount());
            if (this.includeValues != null) {
                for (BytesRef term : this.includeValues) {
                    ord = globalOrdinals.lookupTerm(term);
                    if (ord < 0L) continue;
                    acceptedGlobalOrdinals.set(ord);
                }
            } else if (acceptedGlobalOrdinals.length() > 0L) {
                acceptedGlobalOrdinals.set(0L, acceptedGlobalOrdinals.length());
            }
            if (this.excludeValues != null) {
                for (BytesRef term : this.excludeValues) {
                    ord = globalOrdinals.lookupTerm(term);
                    if (ord < 0L) continue;
                    acceptedGlobalOrdinals.clear(ord);
                }
            }
            return acceptedGlobalOrdinals;
        }
    }

    public class PartitionedLongFilter
    extends LongFilter {
        @Override
        public boolean accept(long value) {
            long hashCode = BitMixer.mix64((long)value);
            return Math.floorMod(hashCode, IncludeExclude.this.incNumPartitions) == IncludeExclude.this.incZeroBasedPartition;
        }
    }

    public static class SetBackedLongFilter
    extends LongFilter {
        private LongSet valids;
        private LongSet invalids;

        private SetBackedLongFilter(int numValids, int numInvalids) {
            if (numValids > 0) {
                this.valids = new LongHashSet(numValids);
            }
            if (numInvalids > 0) {
                this.invalids = new LongHashSet(numInvalids);
            }
        }

        @Override
        public boolean accept(long value) {
            return !(this.valids != null && !this.valids.contains(value) || this.invalids != null && this.invalids.contains(value));
        }

        private void addAccept(long val) {
            this.valids.add(val);
        }

        private void addReject(long val) {
            this.invalids.add(val);
        }
    }

    private static class DocValuesTerms
    extends Terms {
        private final SortedSetDocValues values;

        DocValuesTerms(SortedSetDocValues values) {
            this.values = values;
        }

        public TermsEnum iterator() throws IOException {
            return this.values.termsEnum();
        }

        public long size() throws IOException {
            return -1L;
        }

        public long getSumTotalTermFreq() throws IOException {
            return -1L;
        }

        public long getSumDocFreq() throws IOException {
            return -1L;
        }

        public int getDocCount() throws IOException {
            return -1;
        }

        public boolean hasFreqs() {
            return false;
        }

        public boolean hasOffsets() {
            return false;
        }

        public boolean hasPositions() {
            return false;
        }

        public boolean hasPayloads() {
            return false;
        }
    }

    public static abstract class OrdinalsFilter
    extends Filter {
        public abstract LongBitSet acceptedGlobalOrdinals(SortedSetDocValues var1) throws IOException;
    }

    public static abstract class StringFilter
    extends Filter {
        public abstract boolean accept(BytesRef var1);
    }

    public static abstract class LongFilter
    extends Filter {
        public abstract boolean accept(long var1);
    }

    public static abstract class Filter {
    }
}

