/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.Map;
import org.easysearch.index.query.QueryShardContext;
import org.easysearch.search.aggregations.Aggregator;
import org.easysearch.search.aggregations.AggregatorFactories;
import org.easysearch.search.aggregations.AggregatorFactory;
import org.easysearch.search.aggregations.CardinalityUpperBound;
import org.easysearch.search.aggregations.bucket.histogram.VariableWidthHistogramAggregationBuilder;
import org.easysearch.search.aggregations.bucket.histogram.VariableWidthHistogramAggregator;
import org.easysearch.search.aggregations.support.CoreValuesSourceType;
import org.easysearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.easysearch.search.aggregations.support.ValuesSourceConfig;
import org.easysearch.search.aggregations.support.ValuesSourceRegistry;
import org.easysearch.search.internal.SearchContext;

public class VariableWidthHistogramAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final int numBuckets;
    private final int shardSize;
    private final int initialBuffer;

    public static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register(VariableWidthHistogramAggregationBuilder.REGISTRY_KEY, CoreValuesSourceType.NUMERIC, VariableWidthHistogramAggregator::new, true);
    }

    VariableWidthHistogramAggregatorFactory(String name, ValuesSourceConfig config, int numBuckets, int shardSize, int initialBuffer, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, queryShardContext, parent, subFactoriesBuilder, metadata);
        this.numBuckets = numBuckets;
        this.shardSize = shardSize;
        this.initialBuffer = initialBuffer;
    }

    @Override
    protected Aggregator doCreateInternal(SearchContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        if (cardinality != CardinalityUpperBound.ONE) {
            throw new IllegalArgumentException("[variable_width_histogram] cannot be nested inside an aggregation that collects more than a single bucket.");
        }
        return this.queryShardContext.getValuesSourceRegistry().getAggregator(VariableWidthHistogramAggregationBuilder.REGISTRY_KEY, this.config).build(this.name, this.factories, this.numBuckets, this.shardSize, this.initialBuffer, this.config, searchContext, parent, metadata);
    }

    @Override
    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new VariableWidthHistogramAggregator(this.name, this.factories, this.numBuckets, this.shardSize, this.initialBuffer, this.config, searchContext, parent, metadata);
    }
}

