/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ScoreMode;
import org.easysearch.index.fielddata.SortedNumericDoubleValues;
import org.easysearch.search.aggregations.Aggregator;
import org.easysearch.search.aggregations.AggregatorFactories;
import org.easysearch.search.aggregations.BucketOrder;
import org.easysearch.search.aggregations.CardinalityUpperBound;
import org.easysearch.search.aggregations.LeafBucketCollector;
import org.easysearch.search.aggregations.LeafBucketCollectorBase;
import org.easysearch.search.aggregations.bucket.histogram.AbstractHistogramAggregator;
import org.easysearch.search.aggregations.bucket.histogram.DoubleBounds;
import org.easysearch.search.aggregations.support.ValuesSource;
import org.easysearch.search.aggregations.support.ValuesSourceConfig;
import org.easysearch.search.internal.SearchContext;

public class NumericHistogramAggregator
extends AbstractHistogramAggregator {
    private final ValuesSource.Numeric valuesSource;

    public NumericHistogramAggregator(String name, AggregatorFactories factories, double interval, double offset, BucketOrder order, boolean keyed, long minDocCount, DoubleBounds extendedBounds, DoubleBounds hardBounds, ValuesSourceConfig valuesSourceConfig, SearchContext context, Aggregator parent, CardinalityUpperBound cardinalityUpperBound, Map<String, Object> metadata) throws IOException {
        super(name, factories, interval, offset, order, keyed, minDocCount, extendedBounds, hardBounds, valuesSourceConfig.format(), context, parent, cardinalityUpperBound, metadata);
        this.valuesSource = valuesSourceConfig.hasValues() ? (ValuesSource.Numeric)valuesSourceConfig.getValuesSource() : null;
    }

    @Override
    public ScoreMode scoreMode() {
        if (this.valuesSource != null && this.valuesSource.needsScores()) {
            return ScoreMode.COMPLETE;
        }
        return super.scoreMode();
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final SortedNumericDoubleValues values = this.valuesSource.doubleValues(ctx);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long owningBucketOrd) throws IOException {
                if (values.advanceExact(doc)) {
                    int valuesCount = values.docValueCount();
                    double previousKey = Double.NEGATIVE_INFINITY;
                    for (int i = 0; i < valuesCount; ++i) {
                        double value = values.nextValue();
                        double key = Math.floor((value - NumericHistogramAggregator.this.offset) / NumericHistogramAggregator.this.interval);
                        assert (key >= previousKey);
                        if (key == previousKey) continue;
                        if (NumericHistogramAggregator.this.hardBounds == null || NumericHistogramAggregator.this.hardBounds.contain(key * NumericHistogramAggregator.this.interval)) {
                            long bucketOrd = NumericHistogramAggregator.this.bucketOrds.add(owningBucketOrd, Double.doubleToLongBits(key));
                            if (bucketOrd < 0L) {
                                bucketOrd = -1L - bucketOrd;
                                NumericHistogramAggregator.this.collectExistingBucket(sub, doc, bucketOrd);
                            } else {
                                NumericHistogramAggregator.this.collectBucket(sub, doc, bucketOrd);
                            }
                        }
                        previousKey = key;
                    }
                }
            }
        };
    }
}

