/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.Map;
import org.easysearch.common.Rounding;
import org.easysearch.common.collect.List;
import org.easysearch.index.query.QueryShardContext;
import org.easysearch.search.aggregations.Aggregator;
import org.easysearch.search.aggregations.AggregatorFactories;
import org.easysearch.search.aggregations.AggregatorFactory;
import org.easysearch.search.aggregations.BucketOrder;
import org.easysearch.search.aggregations.CardinalityUpperBound;
import org.easysearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.easysearch.search.aggregations.bucket.histogram.DateHistogramAggregationSupplier;
import org.easysearch.search.aggregations.bucket.histogram.DateHistogramAggregator;
import org.easysearch.search.aggregations.bucket.histogram.DateRangeHistogramAggregator;
import org.easysearch.search.aggregations.bucket.histogram.LongBounds;
import org.easysearch.search.aggregations.support.CoreValuesSourceType;
import org.easysearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.easysearch.search.aggregations.support.ValuesSourceConfig;
import org.easysearch.search.aggregations.support.ValuesSourceRegistry;
import org.easysearch.search.internal.SearchContext;

public final class DateHistogramAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final BucketOrder order;
    private final boolean keyed;
    private final long minDocCount;
    private final LongBounds extendedBounds;
    private final LongBounds hardBounds;
    private final Rounding rounding;

    public static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register(DateHistogramAggregationBuilder.REGISTRY_KEY, List.of(CoreValuesSourceType.DATE, CoreValuesSourceType.NUMERIC, CoreValuesSourceType.BOOLEAN), DateHistogramAggregator::new, true);
        builder.register(DateHistogramAggregationBuilder.REGISTRY_KEY, CoreValuesSourceType.RANGE, DateRangeHistogramAggregator::new, true);
    }

    public DateHistogramAggregatorFactory(String name, ValuesSourceConfig config, BucketOrder order, boolean keyed, long minDocCount, Rounding rounding, LongBounds extendedBounds, LongBounds hardBounds, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, queryShardContext, parent, subFactoriesBuilder, metadata);
        this.order = order;
        this.keyed = keyed;
        this.minDocCount = minDocCount;
        this.extendedBounds = extendedBounds;
        this.hardBounds = hardBounds;
        this.rounding = rounding;
    }

    public long minDocCount() {
        return this.minDocCount;
    }

    @Override
    protected Aggregator doCreateInternal(SearchContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        DateHistogramAggregationSupplier aggregatorSupplier = this.queryShardContext.getValuesSourceRegistry().getAggregator(DateHistogramAggregationBuilder.REGISTRY_KEY, this.config);
        Rounding.Prepared preparedRounding = this.config.getValuesSource().roundingPreparer(this.queryShardContext.getIndexReader()).apply(this.rounding);
        return aggregatorSupplier.build(this.name, this.factories, this.rounding, preparedRounding, this.order, this.keyed, this.minDocCount, this.extendedBounds, this.hardBounds, this.config, searchContext, parent, cardinality, metadata);
    }

    @Override
    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new DateHistogramAggregator(this.name, this.factories, this.rounding, null, this.order, this.keyed, this.minDocCount, this.extendedBounds, this.hardBounds, this.config, searchContext, parent, CardinalityUpperBound.NONE, metadata);
    }
}

