/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.aggregations.bucket.filter;

import java.io.IOException;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.easysearch.common.lucene.Lucene;
import org.easysearch.search.aggregations.Aggregator;
import org.easysearch.search.aggregations.AggregatorFactories;
import org.easysearch.search.aggregations.CardinalityUpperBound;
import org.easysearch.search.aggregations.InternalAggregation;
import org.easysearch.search.aggregations.LeafBucketCollector;
import org.easysearch.search.aggregations.LeafBucketCollectorBase;
import org.easysearch.search.aggregations.bucket.BucketsAggregator;
import org.easysearch.search.aggregations.bucket.SingleBucketAggregator;
import org.easysearch.search.aggregations.bucket.filter.InternalFilter;
import org.easysearch.search.internal.SearchContext;

public class FilterAggregator
extends BucketsAggregator
implements SingleBucketAggregator {
    private final Supplier<Weight> filter;

    public FilterAggregator(String name, Supplier<Weight> filter, AggregatorFactories factories, SearchContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        super(name, factories, context, parent, cardinality, metadata);
        this.filter = filter;
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        final Bits bits = Lucene.asSequentialAccessBits(ctx.reader().maxDoc(), this.filter.get().scorerSupplier(ctx));
        return new LeafBucketCollectorBase(sub, null){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (bits.get(doc)) {
                    FilterAggregator.this.collectBucket(sub, doc, bucket);
                }
            }
        };
    }

    @Override
    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        return this.buildAggregationsForSingleBucket(owningBucketOrds, (owningBucketOrd, subAggregationResults) -> new InternalFilter(this.name, this.bucketDocCount(owningBucketOrd), subAggregationResults, this.metadata()));
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalFilter(this.name, 0L, this.buildEmptySubAggregations(), this.metadata());
    }
}

