/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.aggregations.bucket.composite;

import java.io.IOException;
import org.easysearch.common.ParseField;
import org.easysearch.common.ParsingException;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.common.xcontent.AbstractObjectParser;
import org.easysearch.common.xcontent.ObjectParser;
import org.easysearch.common.xcontent.ToXContent;
import org.easysearch.common.xcontent.XContentBuilder;
import org.easysearch.common.xcontent.XContentParser;
import org.easysearch.common.xcontent.XContentParserUtils;
import org.easysearch.script.Script;
import org.easysearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.easysearch.search.aggregations.bucket.composite.DateHistogramValuesSourceBuilder;
import org.easysearch.search.aggregations.bucket.composite.GeoTileGridValuesSourceBuilder;
import org.easysearch.search.aggregations.bucket.composite.HistogramValuesSourceBuilder;
import org.easysearch.search.aggregations.bucket.composite.TermsValuesSourceBuilder;
import org.easysearch.search.aggregations.support.ValueType;

public class CompositeValuesSourceParserHelper {
    static <VB extends CompositeValuesSourceBuilder<VB>, T> void declareValuesSourceFields(AbstractObjectParser<VB, T> objectParser) {
        objectParser.declareField(CompositeValuesSourceBuilder::field, XContentParser::text, new ParseField("field", new String[0]), ObjectParser.ValueType.STRING);
        objectParser.declareBoolean(CompositeValuesSourceBuilder::missingBucket, new ParseField("missing_bucket", new String[0]));
        objectParser.declareField(CompositeValuesSourceBuilder::userValuetypeHint, p -> {
            ValueType valueType = ValueType.lenientParse(p.text());
            return valueType;
        }, new ParseField("value_type", new String[0]), ObjectParser.ValueType.STRING);
        objectParser.declareField(CompositeValuesSourceBuilder::script, (parser, context) -> Script.parse(parser), Script.SCRIPT_PARSE_FIELD, ObjectParser.ValueType.OBJECT_OR_STRING);
        objectParser.declareField(CompositeValuesSourceBuilder::order, XContentParser::text, new ParseField("order", new String[0]), ObjectParser.ValueType.STRING);
    }

    public static void writeTo(CompositeValuesSourceBuilder<?> builder, StreamOutput out) throws IOException {
        int code;
        if (builder.getClass() == TermsValuesSourceBuilder.class) {
            code = 0;
        } else if (builder.getClass() == DateHistogramValuesSourceBuilder.class) {
            code = 1;
        } else if (builder.getClass() == HistogramValuesSourceBuilder.class) {
            code = 2;
        } else if (builder.getClass() == GeoTileGridValuesSourceBuilder.class) {
            code = 3;
        } else {
            throw new IOException("invalid builder type: " + builder.getClass().getSimpleName());
        }
        out.writeByte((byte)code);
        builder.writeTo(out);
    }

    public static CompositeValuesSourceBuilder<?> readFrom(StreamInput in) throws IOException {
        byte code = in.readByte();
        switch (code) {
            case 0: {
                return new TermsValuesSourceBuilder(in);
            }
            case 1: {
                return new DateHistogramValuesSourceBuilder(in);
            }
            case 2: {
                return new HistogramValuesSourceBuilder(in);
            }
            case 3: {
                return new GeoTileGridValuesSourceBuilder(in);
            }
        }
        throw new IOException("Invalid code " + code);
    }

    public static CompositeValuesSourceBuilder<?> fromXContent(XContentParser parser) throws IOException {
        CompositeValuesSourceBuilder builder;
        XContentParser.Token token = parser.currentToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser);
        token = parser.nextToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser);
        String name = parser.currentName();
        token = parser.nextToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser);
        token = parser.nextToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser);
        String type = parser.currentName();
        token = parser.nextToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser);
        switch (type) {
            case "terms": {
                builder = TermsValuesSourceBuilder.parse(name, parser);
                break;
            }
            case "date_histogram": {
                builder = DateHistogramValuesSourceBuilder.PARSER.parse(parser, name);
                break;
            }
            case "histogram": {
                builder = HistogramValuesSourceBuilder.parse(name, parser);
                break;
            }
            case "geotile_grid": {
                builder = GeoTileGridValuesSourceBuilder.parse(name, parser);
                break;
            }
            default: {
                throw new ParsingException(parser.getTokenLocation(), "invalid source type: " + type, new Object[0]);
            }
        }
        parser.nextToken();
        parser.nextToken();
        return builder;
    }

    public static XContentBuilder toXContent(CompositeValuesSourceBuilder<?> source, XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(source.name());
        source.toXContent(builder, params);
        builder.endObject();
        builder.endObject();
        return builder;
    }
}

