/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.lucene.search.BooleanQuery;
import org.easysearch.common.CheckedFunction;
import org.easysearch.common.NamedRegistry;
import org.easysearch.common.ParseField;
import org.easysearch.common.geo.GeoShapeType;
import org.easysearch.common.geo.ShapesAvailability;
import org.easysearch.common.io.stream.NamedWriteableRegistry;
import org.easysearch.common.io.stream.Writeable;
import org.easysearch.common.settings.Setting;
import org.easysearch.common.settings.Settings;
import org.easysearch.common.xcontent.ContextParser;
import org.easysearch.common.xcontent.NamedXContentRegistry;
import org.easysearch.common.xcontent.ParseFieldRegistry;
import org.easysearch.common.xcontent.XContentParser;
import org.easysearch.index.query.BoolQueryBuilder;
import org.easysearch.index.query.BoostingQueryBuilder;
import org.easysearch.index.query.CommonTermsQueryBuilder;
import org.easysearch.index.query.ConstantScoreQueryBuilder;
import org.easysearch.index.query.DisMaxQueryBuilder;
import org.easysearch.index.query.DistanceFeatureQueryBuilder;
import org.easysearch.index.query.ExistsQueryBuilder;
import org.easysearch.index.query.FieldMaskingSpanQueryBuilder;
import org.easysearch.index.query.FuzzyQueryBuilder;
import org.easysearch.index.query.GeoBoundingBoxQueryBuilder;
import org.easysearch.index.query.GeoDistanceQueryBuilder;
import org.easysearch.index.query.GeoPolygonQueryBuilder;
import org.easysearch.index.query.GeoShapeQueryBuilder;
import org.easysearch.index.query.IdsQueryBuilder;
import org.easysearch.index.query.IntervalQueryBuilder;
import org.easysearch.index.query.IntervalsSourceProvider;
import org.easysearch.index.query.MatchAllQueryBuilder;
import org.easysearch.index.query.MatchBoolPrefixQueryBuilder;
import org.easysearch.index.query.MatchNoneQueryBuilder;
import org.easysearch.index.query.MatchPhrasePrefixQueryBuilder;
import org.easysearch.index.query.MatchPhraseQueryBuilder;
import org.easysearch.index.query.MatchQueryBuilder;
import org.easysearch.index.query.MoreLikeThisQueryBuilder;
import org.easysearch.index.query.MultiMatchQueryBuilder;
import org.easysearch.index.query.NestedQueryBuilder;
import org.easysearch.index.query.PrefixQueryBuilder;
import org.easysearch.index.query.QueryBuilder;
import org.easysearch.index.query.QueryParser;
import org.easysearch.index.query.QueryStringQueryBuilder;
import org.easysearch.index.query.RangeQueryBuilder;
import org.easysearch.index.query.RegexpQueryBuilder;
import org.easysearch.index.query.ScriptQueryBuilder;
import org.easysearch.index.query.SimpleQueryStringBuilder;
import org.easysearch.index.query.SpanContainingQueryBuilder;
import org.easysearch.index.query.SpanFirstQueryBuilder;
import org.easysearch.index.query.SpanMultiTermQueryBuilder;
import org.easysearch.index.query.SpanNearQueryBuilder;
import org.easysearch.index.query.SpanNotQueryBuilder;
import org.easysearch.index.query.SpanOrQueryBuilder;
import org.easysearch.index.query.SpanTermQueryBuilder;
import org.easysearch.index.query.SpanWithinQueryBuilder;
import org.easysearch.index.query.TermQueryBuilder;
import org.easysearch.index.query.TermsQueryBuilder;
import org.easysearch.index.query.TermsSetQueryBuilder;
import org.easysearch.index.query.TypeQueryBuilder;
import org.easysearch.index.query.WildcardQueryBuilder;
import org.easysearch.index.query.WrapperQueryBuilder;
import org.easysearch.index.query.functionscore.ExponentialDecayFunctionBuilder;
import org.easysearch.index.query.functionscore.FieldValueFactorFunctionBuilder;
import org.easysearch.index.query.functionscore.FunctionScoreQueryBuilder;
import org.easysearch.index.query.functionscore.GaussDecayFunctionBuilder;
import org.easysearch.index.query.functionscore.LinearDecayFunctionBuilder;
import org.easysearch.index.query.functionscore.RandomScoreFunctionBuilder;
import org.easysearch.index.query.functionscore.ScoreFunctionBuilder;
import org.easysearch.index.query.functionscore.ScoreFunctionParser;
import org.easysearch.index.query.functionscore.ScriptScoreFunctionBuilder;
import org.easysearch.index.query.functionscore.ScriptScoreQueryBuilder;
import org.easysearch.index.query.functionscore.WeightBuilder;
import org.easysearch.plugins.SearchPlugin;
import org.easysearch.search.DocValueFormat;
import org.easysearch.search.SearchExtBuilder;
import org.easysearch.search.aggregations.AggregationBuilder;
import org.easysearch.search.aggregations.BaseAggregationBuilder;
import org.easysearch.search.aggregations.InternalAggregation;
import org.easysearch.search.aggregations.PipelineAggregationBuilder;
import org.easysearch.search.aggregations.bucket.adjacency.AdjacencyMatrixAggregationBuilder;
import org.easysearch.search.aggregations.bucket.adjacency.InternalAdjacencyMatrix;
import org.easysearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.easysearch.search.aggregations.bucket.composite.InternalComposite;
import org.easysearch.search.aggregations.bucket.filter.FilterAggregationBuilder;
import org.easysearch.search.aggregations.bucket.filter.FiltersAggregationBuilder;
import org.easysearch.search.aggregations.bucket.filter.InternalFilter;
import org.easysearch.search.aggregations.bucket.filter.InternalFilters;
import org.easysearch.search.aggregations.bucket.geogrid.GeoHashGridAggregationBuilder;
import org.easysearch.search.aggregations.bucket.geogrid.GeoTileGridAggregationBuilder;
import org.easysearch.search.aggregations.bucket.geogrid.InternalGeoHashGrid;
import org.easysearch.search.aggregations.bucket.geogrid.InternalGeoTileGrid;
import org.easysearch.search.aggregations.bucket.global.GlobalAggregationBuilder;
import org.easysearch.search.aggregations.bucket.global.InternalGlobal;
import org.easysearch.search.aggregations.bucket.histogram.AutoDateHistogramAggregationBuilder;
import org.easysearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.easysearch.search.aggregations.bucket.histogram.HistogramAggregationBuilder;
import org.easysearch.search.aggregations.bucket.histogram.InternalAutoDateHistogram;
import org.easysearch.search.aggregations.bucket.histogram.InternalDateHistogram;
import org.easysearch.search.aggregations.bucket.histogram.InternalHistogram;
import org.easysearch.search.aggregations.bucket.histogram.InternalVariableWidthHistogram;
import org.easysearch.search.aggregations.bucket.histogram.VariableWidthHistogramAggregationBuilder;
import org.easysearch.search.aggregations.bucket.missing.InternalMissing;
import org.easysearch.search.aggregations.bucket.missing.MissingAggregationBuilder;
import org.easysearch.search.aggregations.bucket.nested.InternalNested;
import org.easysearch.search.aggregations.bucket.nested.InternalReverseNested;
import org.easysearch.search.aggregations.bucket.nested.NestedAggregationBuilder;
import org.easysearch.search.aggregations.bucket.nested.ReverseNestedAggregationBuilder;
import org.easysearch.search.aggregations.bucket.range.DateRangeAggregationBuilder;
import org.easysearch.search.aggregations.bucket.range.GeoDistanceAggregationBuilder;
import org.easysearch.search.aggregations.bucket.range.InternalBinaryRange;
import org.easysearch.search.aggregations.bucket.range.InternalDateRange;
import org.easysearch.search.aggregations.bucket.range.InternalGeoDistance;
import org.easysearch.search.aggregations.bucket.range.InternalRange;
import org.easysearch.search.aggregations.bucket.range.IpRangeAggregationBuilder;
import org.easysearch.search.aggregations.bucket.range.RangeAggregationBuilder;
import org.easysearch.search.aggregations.bucket.sampler.DiversifiedAggregationBuilder;
import org.easysearch.search.aggregations.bucket.sampler.InternalSampler;
import org.easysearch.search.aggregations.bucket.sampler.SamplerAggregationBuilder;
import org.easysearch.search.aggregations.bucket.sampler.UnmappedSampler;
import org.easysearch.search.aggregations.bucket.terms.DoubleTerms;
import org.easysearch.search.aggregations.bucket.terms.LongRareTerms;
import org.easysearch.search.aggregations.bucket.terms.LongTerms;
import org.easysearch.search.aggregations.bucket.terms.RareTermsAggregationBuilder;
import org.easysearch.search.aggregations.bucket.terms.SignificantLongTerms;
import org.easysearch.search.aggregations.bucket.terms.SignificantStringTerms;
import org.easysearch.search.aggregations.bucket.terms.SignificantTermsAggregationBuilder;
import org.easysearch.search.aggregations.bucket.terms.SignificantTextAggregationBuilder;
import org.easysearch.search.aggregations.bucket.terms.StringRareTerms;
import org.easysearch.search.aggregations.bucket.terms.StringTerms;
import org.easysearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.easysearch.search.aggregations.bucket.terms.UnmappedRareTerms;
import org.easysearch.search.aggregations.bucket.terms.UnmappedSignificantTerms;
import org.easysearch.search.aggregations.bucket.terms.UnmappedTerms;
import org.easysearch.search.aggregations.bucket.terms.heuristic.ChiSquare;
import org.easysearch.search.aggregations.bucket.terms.heuristic.GND;
import org.easysearch.search.aggregations.bucket.terms.heuristic.JLHScore;
import org.easysearch.search.aggregations.bucket.terms.heuristic.MutualInformation;
import org.easysearch.search.aggregations.bucket.terms.heuristic.PercentageScore;
import org.easysearch.search.aggregations.bucket.terms.heuristic.ScriptHeuristic;
import org.easysearch.search.aggregations.bucket.terms.heuristic.SignificanceHeuristic;
import org.easysearch.search.aggregations.metrics.AvgAggregationBuilder;
import org.easysearch.search.aggregations.metrics.CardinalityAggregationBuilder;
import org.easysearch.search.aggregations.metrics.ExtendedStatsAggregationBuilder;
import org.easysearch.search.aggregations.metrics.GeoBoundsAggregationBuilder;
import org.easysearch.search.aggregations.metrics.GeoCentroidAggregationBuilder;
import org.easysearch.search.aggregations.metrics.InternalAvg;
import org.easysearch.search.aggregations.metrics.InternalCardinality;
import org.easysearch.search.aggregations.metrics.InternalExtendedStats;
import org.easysearch.search.aggregations.metrics.InternalGeoBounds;
import org.easysearch.search.aggregations.metrics.InternalGeoCentroid;
import org.easysearch.search.aggregations.metrics.InternalHDRPercentileRanks;
import org.easysearch.search.aggregations.metrics.InternalHDRPercentiles;
import org.easysearch.search.aggregations.metrics.InternalMax;
import org.easysearch.search.aggregations.metrics.InternalMedianAbsoluteDeviation;
import org.easysearch.search.aggregations.metrics.InternalMin;
import org.easysearch.search.aggregations.metrics.InternalScriptedMetric;
import org.easysearch.search.aggregations.metrics.InternalStats;
import org.easysearch.search.aggregations.metrics.InternalSum;
import org.easysearch.search.aggregations.metrics.InternalTDigestPercentileRanks;
import org.easysearch.search.aggregations.metrics.InternalTDigestPercentiles;
import org.easysearch.search.aggregations.metrics.InternalTopHits;
import org.easysearch.search.aggregations.metrics.InternalValueCount;
import org.easysearch.search.aggregations.metrics.InternalWeightedAvg;
import org.easysearch.search.aggregations.metrics.MaxAggregationBuilder;
import org.easysearch.search.aggregations.metrics.MedianAbsoluteDeviationAggregationBuilder;
import org.easysearch.search.aggregations.metrics.MinAggregationBuilder;
import org.easysearch.search.aggregations.metrics.PercentileRanksAggregationBuilder;
import org.easysearch.search.aggregations.metrics.PercentilesAggregationBuilder;
import org.easysearch.search.aggregations.metrics.ScriptedMetricAggregationBuilder;
import org.easysearch.search.aggregations.metrics.StatsAggregationBuilder;
import org.easysearch.search.aggregations.metrics.SumAggregationBuilder;
import org.easysearch.search.aggregations.metrics.TopHitsAggregationBuilder;
import org.easysearch.search.aggregations.metrics.ValueCountAggregationBuilder;
import org.easysearch.search.aggregations.metrics.WeightedAvgAggregationBuilder;
import org.easysearch.search.aggregations.pipeline.AvgBucketPipelineAggregationBuilder;
import org.easysearch.search.aggregations.pipeline.AvgBucketPipelineAggregator;
import org.easysearch.search.aggregations.pipeline.BucketScriptPipelineAggregationBuilder;
import org.easysearch.search.aggregations.pipeline.BucketScriptPipelineAggregator;
import org.easysearch.search.aggregations.pipeline.BucketSelectorPipelineAggregationBuilder;
import org.easysearch.search.aggregations.pipeline.BucketSelectorPipelineAggregator;
import org.easysearch.search.aggregations.pipeline.BucketSortPipelineAggregationBuilder;
import org.easysearch.search.aggregations.pipeline.BucketSortPipelineAggregator;
import org.easysearch.search.aggregations.pipeline.CumulativeSumPipelineAggregationBuilder;
import org.easysearch.search.aggregations.pipeline.CumulativeSumPipelineAggregator;
import org.easysearch.search.aggregations.pipeline.DerivativePipelineAggregationBuilder;
import org.easysearch.search.aggregations.pipeline.DerivativePipelineAggregator;
import org.easysearch.search.aggregations.pipeline.EwmaModel;
import org.easysearch.search.aggregations.pipeline.ExtendedStatsBucketParser;
import org.easysearch.search.aggregations.pipeline.ExtendedStatsBucketPipelineAggregationBuilder;
import org.easysearch.search.aggregations.pipeline.ExtendedStatsBucketPipelineAggregator;
import org.easysearch.search.aggregations.pipeline.HoltLinearModel;
import org.easysearch.search.aggregations.pipeline.HoltWintersModel;
import org.easysearch.search.aggregations.pipeline.InternalBucketMetricValue;
import org.easysearch.search.aggregations.pipeline.InternalDerivative;
import org.easysearch.search.aggregations.pipeline.InternalExtendedStatsBucket;
import org.easysearch.search.aggregations.pipeline.InternalPercentilesBucket;
import org.easysearch.search.aggregations.pipeline.InternalSimpleValue;
import org.easysearch.search.aggregations.pipeline.InternalStatsBucket;
import org.easysearch.search.aggregations.pipeline.LinearModel;
import org.easysearch.search.aggregations.pipeline.MaxBucketPipelineAggregationBuilder;
import org.easysearch.search.aggregations.pipeline.MaxBucketPipelineAggregator;
import org.easysearch.search.aggregations.pipeline.MinBucketPipelineAggregationBuilder;
import org.easysearch.search.aggregations.pipeline.MinBucketPipelineAggregator;
import org.easysearch.search.aggregations.pipeline.MovAvgModel;
import org.easysearch.search.aggregations.pipeline.MovAvgPipelineAggregationBuilder;
import org.easysearch.search.aggregations.pipeline.MovAvgPipelineAggregator;
import org.easysearch.search.aggregations.pipeline.MovFnPipelineAggregationBuilder;
import org.easysearch.search.aggregations.pipeline.MovFnPipelineAggregator;
import org.easysearch.search.aggregations.pipeline.PercentilesBucketPipelineAggregationBuilder;
import org.easysearch.search.aggregations.pipeline.PercentilesBucketPipelineAggregator;
import org.easysearch.search.aggregations.pipeline.PipelineAggregator;
import org.easysearch.search.aggregations.pipeline.SerialDiffPipelineAggregationBuilder;
import org.easysearch.search.aggregations.pipeline.SerialDiffPipelineAggregator;
import org.easysearch.search.aggregations.pipeline.SimpleModel;
import org.easysearch.search.aggregations.pipeline.StatsBucketPipelineAggregationBuilder;
import org.easysearch.search.aggregations.pipeline.StatsBucketPipelineAggregator;
import org.easysearch.search.aggregations.pipeline.SumBucketPipelineAggregationBuilder;
import org.easysearch.search.aggregations.pipeline.SumBucketPipelineAggregator;
import org.easysearch.search.aggregations.support.ValuesSourceRegistry;
import org.easysearch.search.fetch.FetchPhase;
import org.easysearch.search.fetch.FetchSubPhase;
import org.easysearch.search.fetch.subphase.ExplainPhase;
import org.easysearch.search.fetch.subphase.FetchDocValuesPhase;
import org.easysearch.search.fetch.subphase.FetchFieldsPhase;
import org.easysearch.search.fetch.subphase.FetchScorePhase;
import org.easysearch.search.fetch.subphase.FetchSourcePhase;
import org.easysearch.search.fetch.subphase.FetchVersionPhase;
import org.easysearch.search.fetch.subphase.MatchedQueriesPhase;
import org.easysearch.search.fetch.subphase.ScriptFieldsPhase;
import org.easysearch.search.fetch.subphase.SeqNoPrimaryTermPhase;
import org.easysearch.search.fetch.subphase.highlight.FastVectorHighlighter;
import org.easysearch.search.fetch.subphase.highlight.HighlightPhase;
import org.easysearch.search.fetch.subphase.highlight.Highlighter;
import org.easysearch.search.fetch.subphase.highlight.PlainHighlighter;
import org.easysearch.search.fetch.subphase.highlight.UnifiedHighlighter;
import org.easysearch.search.rescore.QueryRescorerBuilder;
import org.easysearch.search.rescore.RescorerBuilder;
import org.easysearch.search.sort.FieldSortBuilder;
import org.easysearch.search.sort.GeoDistanceSortBuilder;
import org.easysearch.search.sort.ScoreSortBuilder;
import org.easysearch.search.sort.ScriptSortBuilder;
import org.easysearch.search.sort.SortBuilder;
import org.easysearch.search.sort.SortValue;
import org.easysearch.search.suggest.Suggest;
import org.easysearch.search.suggest.SuggestionBuilder;
import org.easysearch.search.suggest.completion.CompletionSuggestion;
import org.easysearch.search.suggest.completion.CompletionSuggestionBuilder;
import org.easysearch.search.suggest.phrase.Laplace;
import org.easysearch.search.suggest.phrase.LinearInterpolation;
import org.easysearch.search.suggest.phrase.PhraseSuggestion;
import org.easysearch.search.suggest.phrase.PhraseSuggestionBuilder;
import org.easysearch.search.suggest.phrase.SmoothingModel;
import org.easysearch.search.suggest.phrase.StupidBackoff;
import org.easysearch.search.suggest.term.TermSuggestion;
import org.easysearch.search.suggest.term.TermSuggestionBuilder;

public class SearchModule {
    public static final Setting<Integer> INDICES_MAX_CLAUSE_COUNT_SETTING = Setting.intSetting("indices.query.bool.max_clause_count", 1024, 1, Integer.MAX_VALUE, Setting.Property.NodeScope);
    private final boolean transportClient;
    private final Map<String, Highlighter> highlighters;
    private final ParseFieldRegistry<MovAvgModel.AbstractModelParser> movingAverageModelParserRegistry = new ParseFieldRegistry("moving_avg_model");
    private final List<FetchSubPhase> fetchSubPhases = new ArrayList<FetchSubPhase>();
    private final Settings settings;
    private final List<NamedWriteableRegistry.Entry> namedWriteables = new ArrayList<NamedWriteableRegistry.Entry>();
    private final List<NamedXContentRegistry.Entry> namedXContents = new ArrayList<NamedXContentRegistry.Entry>();
    private final ValuesSourceRegistry valuesSourceRegistry;

    public SearchModule(Settings settings, boolean transportClient, List<SearchPlugin> plugins) {
        this.settings = settings;
        this.transportClient = transportClient;
        this.registerSuggesters(plugins);
        this.highlighters = this.setupHighlighters(settings, plugins);
        this.registerScoreFunctions(plugins);
        this.registerQueryParsers(plugins);
        this.registerRescorers(plugins);
        this.registerSorts();
        this.registerValueFormats();
        this.registerSignificanceHeuristics(plugins);
        this.valuesSourceRegistry = this.registerAggregations(plugins);
        this.registerMovingAverageModels(plugins);
        this.registerPipelineAggregations(plugins);
        this.registerFetchSubPhases(plugins);
        this.registerSearchExts(plugins);
        this.registerShapes();
        this.registerIntervalsSourceProviders();
        this.namedWriteables.addAll(SortValue.namedWriteables());
    }

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return this.namedWriteables;
    }

    public List<NamedXContentRegistry.Entry> getNamedXContents() {
        return this.namedXContents;
    }

    public ValuesSourceRegistry getValuesSourceRegistry() {
        return this.valuesSourceRegistry;
    }

    public Map<String, Highlighter> getHighlighters() {
        return this.highlighters;
    }

    public ParseFieldRegistry<MovAvgModel.AbstractModelParser> getMovingAverageModelParserRegistry() {
        return this.movingAverageModelParserRegistry;
    }

    private ValuesSourceRegistry registerAggregations(List<SearchPlugin> plugins) {
        ValuesSourceRegistry.Builder builder = new ValuesSourceRegistry.Builder();
        this.registerAggregation(new SearchPlugin.AggregationSpec("avg", AvgAggregationBuilder::new, AvgAggregationBuilder.PARSER).addResultReader(InternalAvg::new).setAggregatorRegistrar(AvgAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("weighted_avg", WeightedAvgAggregationBuilder::new, WeightedAvgAggregationBuilder.PARSER).addResultReader(InternalWeightedAvg::new).setAggregatorRegistrar(WeightedAvgAggregationBuilder::registerUsage), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("sum", SumAggregationBuilder::new, SumAggregationBuilder.PARSER).addResultReader(InternalSum::new).setAggregatorRegistrar(SumAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("min", MinAggregationBuilder::new, MinAggregationBuilder.PARSER).addResultReader(InternalMin::new).setAggregatorRegistrar(MinAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("max", MaxAggregationBuilder::new, MaxAggregationBuilder.PARSER).addResultReader(InternalMax::new).setAggregatorRegistrar(MaxAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("stats", StatsAggregationBuilder::new, StatsAggregationBuilder.PARSER).addResultReader(InternalStats::new).setAggregatorRegistrar(StatsAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("extended_stats", ExtendedStatsAggregationBuilder::new, ExtendedStatsAggregationBuilder.PARSER).addResultReader(InternalExtendedStats::new).setAggregatorRegistrar(ExtendedStatsAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("value_count", ValueCountAggregationBuilder::new, ValueCountAggregationBuilder.PARSER).addResultReader(InternalValueCount::new).setAggregatorRegistrar(ValueCountAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("percentiles", PercentilesAggregationBuilder::new, PercentilesAggregationBuilder::parse).addResultReader("tdigest_percentiles", InternalTDigestPercentiles::new).addResultReader("hdr_percentiles", InternalHDRPercentiles::new).setAggregatorRegistrar(PercentilesAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("percentile_ranks", PercentileRanksAggregationBuilder::new, PercentileRanksAggregationBuilder::parse).addResultReader("tdigest_percentile_ranks", InternalTDigestPercentileRanks::new).addResultReader("hdr_percentile_ranks", InternalHDRPercentileRanks::new).setAggregatorRegistrar(PercentileRanksAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("median_absolute_deviation", MedianAbsoluteDeviationAggregationBuilder::new, MedianAbsoluteDeviationAggregationBuilder.PARSER).addResultReader(InternalMedianAbsoluteDeviation::new).setAggregatorRegistrar(MedianAbsoluteDeviationAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("cardinality", CardinalityAggregationBuilder::new, CardinalityAggregationBuilder.PARSER).addResultReader(InternalCardinality::new).setAggregatorRegistrar(CardinalityAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("global", GlobalAggregationBuilder::new, GlobalAggregationBuilder::parse).addResultReader(InternalGlobal::new), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("missing", MissingAggregationBuilder::new, MissingAggregationBuilder.PARSER).addResultReader(InternalMissing::new).setAggregatorRegistrar(MissingAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("filter", FilterAggregationBuilder::new, FilterAggregationBuilder::parse).addResultReader(InternalFilter::new), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("filters", FiltersAggregationBuilder::new, FiltersAggregationBuilder::parse).addResultReader(InternalFilters::new), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("adjacency_matrix", AdjacencyMatrixAggregationBuilder::new, AdjacencyMatrixAggregationBuilder::parse).addResultReader(InternalAdjacencyMatrix::new), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("sampler", SamplerAggregationBuilder::new, SamplerAggregationBuilder::parse).addResultReader("mapped_sampler", InternalSampler::new).addResultReader("unmapped_sampler", UnmappedSampler::new), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("diversified_sampler", DiversifiedAggregationBuilder::new, DiversifiedAggregationBuilder.PARSER).setAggregatorRegistrar(DiversifiedAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("terms", TermsAggregationBuilder::new, TermsAggregationBuilder.PARSER).addResultReader("sterms", StringTerms::new).addResultReader("umterms", UnmappedTerms::new).addResultReader("lterms", LongTerms::new).addResultReader("dterms", DoubleTerms::new).setAggregatorRegistrar(TermsAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("rare_terms", RareTermsAggregationBuilder::new, RareTermsAggregationBuilder.PARSER).addResultReader("srareterms", StringRareTerms::new).addResultReader("umrareterms", UnmappedRareTerms::new).addResultReader("lrareterms", LongRareTerms::new).setAggregatorRegistrar(RareTermsAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("significant_terms", SignificantTermsAggregationBuilder::new, SignificantTermsAggregationBuilder::parse).addResultReader("sigsterms", SignificantStringTerms::new).addResultReader("siglterms", SignificantLongTerms::new).addResultReader("umsigterms", UnmappedSignificantTerms::new).setAggregatorRegistrar(SignificantTermsAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("significant_text", SignificantTextAggregationBuilder::new, SignificantTextAggregationBuilder::parse), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("range", RangeAggregationBuilder::new, RangeAggregationBuilder.PARSER).addResultReader(InternalRange::new).setAggregatorRegistrar(RangeAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("date_range", DateRangeAggregationBuilder::new, DateRangeAggregationBuilder.PARSER).addResultReader(InternalDateRange::new).setAggregatorRegistrar(DateRangeAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("ip_range", IpRangeAggregationBuilder::new, IpRangeAggregationBuilder.PARSER).addResultReader(InternalBinaryRange::new).setAggregatorRegistrar(IpRangeAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("histogram", HistogramAggregationBuilder::new, HistogramAggregationBuilder.PARSER).addResultReader(InternalHistogram::new).setAggregatorRegistrar(HistogramAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("date_histogram", DateHistogramAggregationBuilder::new, DateHistogramAggregationBuilder.PARSER).addResultReader(InternalDateHistogram::new).setAggregatorRegistrar(DateHistogramAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("auto_date_histogram", AutoDateHistogramAggregationBuilder::new, AutoDateHistogramAggregationBuilder.PARSER).addResultReader(InternalAutoDateHistogram::new).setAggregatorRegistrar(AutoDateHistogramAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("variable_width_histogram", VariableWidthHistogramAggregationBuilder::new, VariableWidthHistogramAggregationBuilder.PARSER).addResultReader(InternalVariableWidthHistogram::new).setAggregatorRegistrar(VariableWidthHistogramAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("geo_distance", GeoDistanceAggregationBuilder::new, GeoDistanceAggregationBuilder::parse).addResultReader(InternalGeoDistance::new).setAggregatorRegistrar(GeoDistanceAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("geohash_grid", GeoHashGridAggregationBuilder::new, GeoHashGridAggregationBuilder.PARSER).addResultReader(InternalGeoHashGrid::new).setAggregatorRegistrar(GeoHashGridAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("geotile_grid", GeoTileGridAggregationBuilder::new, GeoTileGridAggregationBuilder.PARSER).addResultReader(InternalGeoTileGrid::new).setAggregatorRegistrar(GeoTileGridAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("nested", NestedAggregationBuilder::new, NestedAggregationBuilder::parse).addResultReader(InternalNested::new), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("reverse_nested", ReverseNestedAggregationBuilder::new, ReverseNestedAggregationBuilder::parse).addResultReader(InternalReverseNested::new), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("top_hits", TopHitsAggregationBuilder::new, TopHitsAggregationBuilder::parse).addResultReader(InternalTopHits::new), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("geo_bounds", GeoBoundsAggregationBuilder::new, GeoBoundsAggregationBuilder.PARSER).addResultReader(InternalGeoBounds::new).setAggregatorRegistrar(GeoBoundsAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("geo_centroid", GeoCentroidAggregationBuilder::new, GeoCentroidAggregationBuilder.PARSER).addResultReader(InternalGeoCentroid::new).setAggregatorRegistrar(GeoCentroidAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("scripted_metric", ScriptedMetricAggregationBuilder::new, ScriptedMetricAggregationBuilder.PARSER).addResultReader(InternalScriptedMetric::new), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("composite", CompositeAggregationBuilder::new, CompositeAggregationBuilder.PARSER).addResultReader(InternalComposite::new).setAggregatorRegistrar(CompositeAggregationBuilder::registerAggregators), builder);
        this.registerFromPlugin(plugins, SearchPlugin::getAggregations, agg -> this.registerAggregation((SearchPlugin.AggregationSpec)agg, builder));
        this.registerFromPlugin(plugins, SearchPlugin::getAggregationExtentions, registrar -> {
            if (registrar != null) {
                registrar.accept(builder);
            }
        });
        return builder.build();
    }

    private void registerAggregation(SearchPlugin.AggregationSpec spec, ValuesSourceRegistry.Builder builder) {
        if (!this.transportClient) {
            this.namedXContents.add(new NamedXContentRegistry.Entry(BaseAggregationBuilder.class, spec.getName(), (p, c) -> {
                String name = (String)c;
                return (BaseAggregationBuilder)((ContextParser)spec.getParser()).parse(p, name);
            }));
        }
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(AggregationBuilder.class, spec.getName().getPreferredName(), spec.getReader()));
        for (Map.Entry<String, Writeable.Reader<? extends InternalAggregation>> t : spec.getResultReaders().entrySet()) {
            String writeableName = t.getKey();
            Writeable.Reader<? extends InternalAggregation> internalReader = t.getValue();
            this.namedWriteables.add(new NamedWriteableRegistry.Entry(InternalAggregation.class, writeableName, internalReader));
        }
        Consumer<ValuesSourceRegistry.Builder> register = spec.getAggregatorRegistrar();
        if (register != null) {
            register.accept(builder);
        } else {
            builder.registerUsage(spec.getName().getPreferredName());
        }
    }

    private void registerPipelineAggregations(List<SearchPlugin> plugins) {
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("derivative", DerivativePipelineAggregationBuilder::new, DerivativePipelineAggregator::new, DerivativePipelineAggregationBuilder::parse).addResultReader(InternalDerivative::new));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("max_bucket", MaxBucketPipelineAggregationBuilder::new, MaxBucketPipelineAggregator::new, MaxBucketPipelineAggregationBuilder.PARSER).addResultReader("bucket_metric_value", InternalBucketMetricValue::new));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("min_bucket", MinBucketPipelineAggregationBuilder::new, MinBucketPipelineAggregator::new, MinBucketPipelineAggregationBuilder.PARSER));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("avg_bucket", AvgBucketPipelineAggregationBuilder::new, AvgBucketPipelineAggregator::new, AvgBucketPipelineAggregationBuilder.PARSER).addResultReader("simple_value", InternalSimpleValue::new));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("sum_bucket", SumBucketPipelineAggregationBuilder::new, SumBucketPipelineAggregator::new, SumBucketPipelineAggregationBuilder.PARSER));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("stats_bucket", StatsBucketPipelineAggregationBuilder::new, StatsBucketPipelineAggregator::new, StatsBucketPipelineAggregationBuilder.PARSER).addResultReader(InternalStatsBucket::new));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("extended_stats_bucket", ExtendedStatsBucketPipelineAggregationBuilder::new, ExtendedStatsBucketPipelineAggregator::new, (PipelineAggregator.Parser)new ExtendedStatsBucketParser()).addResultReader(InternalExtendedStatsBucket::new));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("percentiles_bucket", PercentilesBucketPipelineAggregationBuilder::new, PercentilesBucketPipelineAggregator::new, PercentilesBucketPipelineAggregationBuilder.PARSER).addResultReader(InternalPercentilesBucket::new));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("moving_avg", MovAvgPipelineAggregationBuilder::new, MovAvgPipelineAggregator::new, (parser, name) -> MovAvgPipelineAggregationBuilder.parse(this.movingAverageModelParserRegistry, name, parser)));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("cumulative_sum", CumulativeSumPipelineAggregationBuilder::new, CumulativeSumPipelineAggregator::new, CumulativeSumPipelineAggregationBuilder.PARSER));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("bucket_script", BucketScriptPipelineAggregationBuilder::new, BucketScriptPipelineAggregator::new, BucketScriptPipelineAggregationBuilder.PARSER));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("bucket_selector", BucketSelectorPipelineAggregationBuilder::new, BucketSelectorPipelineAggregator::new, BucketSelectorPipelineAggregationBuilder::parse));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("bucket_sort", BucketSortPipelineAggregationBuilder::new, BucketSortPipelineAggregator::new, BucketSortPipelineAggregationBuilder::parse));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("serial_diff", SerialDiffPipelineAggregationBuilder::new, SerialDiffPipelineAggregator::new, SerialDiffPipelineAggregationBuilder::parse));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("moving_fn", MovFnPipelineAggregationBuilder::new, MovFnPipelineAggregator::new, MovFnPipelineAggregationBuilder.PARSER));
        this.registerFromPlugin(plugins, SearchPlugin::getPipelineAggregations, this::registerPipelineAggregation);
    }

    private void registerPipelineAggregation(SearchPlugin.PipelineAggregationSpec spec) {
        if (!this.transportClient) {
            this.namedXContents.add(new NamedXContentRegistry.Entry(BaseAggregationBuilder.class, spec.getName(), (p, c) -> (BaseAggregationBuilder)((ContextParser)spec.getParser()).parse(p, (String)c)));
        }
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(PipelineAggregationBuilder.class, spec.getName().getPreferredName(), spec.getReader()));
        if (spec.getAggregatorReader() != null) {
            this.namedWriteables.add(new NamedWriteableRegistry.Entry(PipelineAggregator.class, spec.getName().getPreferredName(), spec.getAggregatorReader()));
        }
        for (Map.Entry<String, Writeable.Reader<? extends InternalAggregation>> resultReader : spec.getResultReaders().entrySet()) {
            this.namedWriteables.add(new NamedWriteableRegistry.Entry(InternalAggregation.class, resultReader.getKey(), resultReader.getValue()));
        }
    }

    private void registerShapes() {
        if (ShapesAvailability.JTS_AVAILABLE && ShapesAvailability.SPATIAL4J_AVAILABLE) {
            this.namedWriteables.addAll(GeoShapeType.getShapeWriteables());
        }
    }

    private void registerRescorers(List<SearchPlugin> plugins) {
        this.registerRescorer(new SearchPlugin.RescorerSpec<QueryRescorerBuilder>("query", QueryRescorerBuilder::new, QueryRescorerBuilder::fromXContent));
        this.registerFromPlugin(plugins, SearchPlugin::getRescorers, this::registerRescorer);
    }

    private void registerRescorer(SearchPlugin.RescorerSpec<?> spec) {
        if (!this.transportClient) {
            this.namedXContents.add(new NamedXContentRegistry.Entry(RescorerBuilder.class, spec.getName(), (p, c) -> (RescorerBuilder)((CheckedFunction)spec.getParser()).apply(p)));
        }
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(RescorerBuilder.class, spec.getName().getPreferredName(), spec.getReader()));
    }

    private void registerSorts() {
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(SortBuilder.class, "_geo_distance", GeoDistanceSortBuilder::new));
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(SortBuilder.class, "_score", ScoreSortBuilder::new));
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(SortBuilder.class, "_script", ScriptSortBuilder::new));
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(SortBuilder.class, "field_sort", FieldSortBuilder::new));
    }

    private <T> void registerFromPlugin(List<SearchPlugin> plugins, Function<SearchPlugin, List<T>> producer, Consumer<T> consumer) {
        for (SearchPlugin plugin : plugins) {
            for (T t : producer.apply(plugin)) {
                consumer.accept(t);
            }
        }
    }

    public static void registerSmoothingModels(List<NamedWriteableRegistry.Entry> namedWriteables) {
        namedWriteables.add(new NamedWriteableRegistry.Entry(SmoothingModel.class, "laplace", Laplace::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(SmoothingModel.class, "linear", LinearInterpolation::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(SmoothingModel.class, "stupid_backoff", StupidBackoff::new));
    }

    private void registerSuggesters(List<SearchPlugin> plugins) {
        SearchModule.registerSmoothingModels(this.namedWriteables);
        this.registerSuggester(new SearchPlugin.SuggesterSpec<TermSuggestionBuilder>("term", TermSuggestionBuilder::new, TermSuggestionBuilder::fromXContent, TermSuggestion::new));
        this.registerSuggester(new SearchPlugin.SuggesterSpec<PhraseSuggestionBuilder>("phrase", PhraseSuggestionBuilder::new, PhraseSuggestionBuilder::fromXContent, PhraseSuggestion::new));
        this.registerSuggester(new SearchPlugin.SuggesterSpec<CompletionSuggestionBuilder>("completion", CompletionSuggestionBuilder::new, CompletionSuggestionBuilder::fromXContent, CompletionSuggestion::new));
        this.registerFromPlugin(plugins, SearchPlugin::getSuggesters, this::registerSuggester);
    }

    private void registerSuggester(SearchPlugin.SuggesterSpec<?> suggester) {
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(SuggestionBuilder.class, suggester.getName().getPreferredName(), suggester.getReader()));
        this.namedXContents.add(new NamedXContentRegistry.Entry(SuggestionBuilder.class, suggester.getName(), (CheckedFunction)suggester.getParser()));
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(Suggest.Suggestion.class, suggester.getName().getPreferredName(), suggester.getSuggestionReader()));
    }

    private Map<String, Highlighter> setupHighlighters(Settings settings, List<SearchPlugin> plugins) {
        NamedRegistry<Highlighter> highlighters = new NamedRegistry<Highlighter>("highlighter");
        highlighters.register("fvh", new FastVectorHighlighter(settings));
        highlighters.register("plain", new PlainHighlighter());
        highlighters.register("unified", new UnifiedHighlighter());
        highlighters.extractAndRegister(plugins, SearchPlugin::getHighlighters);
        return Collections.unmodifiableMap(highlighters.getRegistry());
    }

    private void registerScoreFunctions(List<SearchPlugin> plugins) {
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(ScriptScoreFunctionBuilder.class, "script_score", ScriptScoreFunctionBuilder::new));
        this.registerScoreFunction(new SearchPlugin.ScoreFunctionSpec<ScriptScoreFunctionBuilder>("script_score", ScriptScoreFunctionBuilder::new, ScriptScoreFunctionBuilder::fromXContent));
        this.registerScoreFunction(new SearchPlugin.ScoreFunctionSpec<GaussDecayFunctionBuilder>("gauss", GaussDecayFunctionBuilder::new, GaussDecayFunctionBuilder.PARSER));
        this.registerScoreFunction(new SearchPlugin.ScoreFunctionSpec<LinearDecayFunctionBuilder>("linear", LinearDecayFunctionBuilder::new, LinearDecayFunctionBuilder.PARSER));
        this.registerScoreFunction(new SearchPlugin.ScoreFunctionSpec<ExponentialDecayFunctionBuilder>("exp", ExponentialDecayFunctionBuilder::new, ExponentialDecayFunctionBuilder.PARSER));
        this.registerScoreFunction(new SearchPlugin.ScoreFunctionSpec<RandomScoreFunctionBuilder>("random_score", RandomScoreFunctionBuilder::new, RandomScoreFunctionBuilder::fromXContent));
        this.registerScoreFunction(new SearchPlugin.ScoreFunctionSpec<FieldValueFactorFunctionBuilder>("field_value_factor", FieldValueFactorFunctionBuilder::new, FieldValueFactorFunctionBuilder::fromXContent));
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(ScoreFunctionBuilder.class, "weight", WeightBuilder::new));
        this.registerFromPlugin(plugins, SearchPlugin::getScoreFunctions, this::registerScoreFunction);
    }

    private void registerScoreFunction(SearchPlugin.ScoreFunctionSpec<?> scoreFunction) {
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(ScoreFunctionBuilder.class, scoreFunction.getName().getPreferredName(), scoreFunction.getReader()));
        this.namedXContents.add(new NamedXContentRegistry.Entry(ScoreFunctionBuilder.class, scoreFunction.getName(), (p, c) -> ((ScoreFunctionParser)scoreFunction.getParser()).fromXContent(p)));
    }

    private void registerValueFormats() {
        this.registerValueFormat(DocValueFormat.BOOLEAN.getWriteableName(), in -> DocValueFormat.BOOLEAN);
        this.registerValueFormat("date_time", DocValueFormat.DateTime::new);
        this.registerValueFormat("decimal", DocValueFormat.Decimal::new);
        this.registerValueFormat(DocValueFormat.GEOHASH.getWriteableName(), in -> DocValueFormat.GEOHASH);
        this.registerValueFormat(DocValueFormat.GEOTILE.getWriteableName(), in -> DocValueFormat.GEOTILE);
        this.registerValueFormat(DocValueFormat.IP.getWriteableName(), in -> DocValueFormat.IP);
        this.registerValueFormat(DocValueFormat.RAW.getWriteableName(), in -> DocValueFormat.RAW);
        this.registerValueFormat(DocValueFormat.BINARY.getWriteableName(), in -> DocValueFormat.BINARY);
        this.registerValueFormat(DocValueFormat.UNSIGNED_LONG_SHIFTED.getWriteableName(), in -> DocValueFormat.UNSIGNED_LONG_SHIFTED);
    }

    private void registerValueFormat(String name, Writeable.Reader<? extends DocValueFormat> reader) {
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(DocValueFormat.class, name, reader));
    }

    private void registerSignificanceHeuristics(List<SearchPlugin> plugins) {
        this.registerSignificanceHeuristic(new SearchPlugin.SignificanceHeuristicSpec<ChiSquare>("chi_square", ChiSquare::new, (BiFunction<XContentParser, Void, ChiSquare>)ChiSquare.PARSER));
        this.registerSignificanceHeuristic(new SearchPlugin.SignificanceHeuristicSpec<GND>("gnd", GND::new, (BiFunction<XContentParser, Void, GND>)GND.PARSER));
        this.registerSignificanceHeuristic(new SearchPlugin.SignificanceHeuristicSpec<JLHScore>("jlh", JLHScore::new, (BiFunction<XContentParser, Void, JLHScore>)JLHScore.PARSER));
        this.registerSignificanceHeuristic(new SearchPlugin.SignificanceHeuristicSpec<MutualInformation>("mutual_information", MutualInformation::new, (BiFunction<XContentParser, Void, MutualInformation>)MutualInformation.PARSER));
        this.registerSignificanceHeuristic(new SearchPlugin.SignificanceHeuristicSpec<PercentageScore>("percentage", PercentageScore::new, (BiFunction<XContentParser, Void, PercentageScore>)PercentageScore.PARSER));
        this.registerSignificanceHeuristic(new SearchPlugin.SignificanceHeuristicSpec<ScriptHeuristic>("script_heuristic", ScriptHeuristic::new, (BiFunction<XContentParser, Void, ScriptHeuristic>)ScriptHeuristic.PARSER));
        this.registerFromPlugin(plugins, SearchPlugin::getSignificanceHeuristics, this::registerSignificanceHeuristic);
    }

    private <T extends SignificanceHeuristic> void registerSignificanceHeuristic(SearchPlugin.SignificanceHeuristicSpec<?> spec) {
        this.namedXContents.add(new NamedXContentRegistry.Entry(SignificanceHeuristic.class, spec.getName(), p -> (SignificanceHeuristic)((BiFunction)spec.getParser()).apply(p, null)));
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(SignificanceHeuristic.class, spec.getName().getPreferredName(), spec.getReader()));
    }

    private void registerMovingAverageModels(List<SearchPlugin> plugins) {
        this.registerMovingAverageModel(new SearchPlugin.SearchExtensionSpec<MovAvgModel, MovAvgModel.AbstractModelParser>("simple", SimpleModel::new, SimpleModel.PARSER));
        this.registerMovingAverageModel(new SearchPlugin.SearchExtensionSpec<MovAvgModel, MovAvgModel.AbstractModelParser>("linear", LinearModel::new, LinearModel.PARSER));
        this.registerMovingAverageModel(new SearchPlugin.SearchExtensionSpec<MovAvgModel, MovAvgModel.AbstractModelParser>("ewma", EwmaModel::new, EwmaModel.PARSER));
        this.registerMovingAverageModel(new SearchPlugin.SearchExtensionSpec<MovAvgModel, MovAvgModel.AbstractModelParser>("holt", HoltLinearModel::new, HoltLinearModel.PARSER));
        this.registerMovingAverageModel(new SearchPlugin.SearchExtensionSpec<MovAvgModel, MovAvgModel.AbstractModelParser>("holt_winters", HoltWintersModel::new, HoltWintersModel.PARSER));
        this.registerFromPlugin(plugins, SearchPlugin::getMovingAverageModels, this::registerMovingAverageModel);
    }

    private void registerMovingAverageModel(SearchPlugin.SearchExtensionSpec<MovAvgModel, MovAvgModel.AbstractModelParser> movAvgModel) {
        this.movingAverageModelParserRegistry.register(movAvgModel.getParser(), movAvgModel.getName());
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(MovAvgModel.class, movAvgModel.getName().getPreferredName(), movAvgModel.getReader()));
    }

    private void registerFetchSubPhases(List<SearchPlugin> plugins) {
        this.registerFetchSubPhase(new ExplainPhase());
        this.registerFetchSubPhase(new FetchDocValuesPhase());
        this.registerFetchSubPhase(new ScriptFieldsPhase());
        this.registerFetchSubPhase(new FetchSourcePhase());
        this.registerFetchSubPhase(new FetchFieldsPhase());
        this.registerFetchSubPhase(new FetchVersionPhase());
        this.registerFetchSubPhase(new SeqNoPrimaryTermPhase());
        this.registerFetchSubPhase(new MatchedQueriesPhase());
        this.registerFetchSubPhase(new HighlightPhase(this.highlighters));
        this.registerFetchSubPhase(new FetchScorePhase());
        SearchPlugin.FetchPhaseConstructionContext context = new SearchPlugin.FetchPhaseConstructionContext(this.highlighters);
        this.registerFromPlugin(plugins, p -> p.getFetchSubPhases(context), this::registerFetchSubPhase);
    }

    private void registerSearchExts(List<SearchPlugin> plugins) {
        this.registerFromPlugin(plugins, SearchPlugin::getSearchExts, this::registerSearchExt);
    }

    private void registerSearchExt(SearchPlugin.SearchExtSpec<?> spec) {
        this.namedXContents.add(new NamedXContentRegistry.Entry(SearchExtBuilder.class, spec.getName(), (CheckedFunction)spec.getParser()));
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(SearchExtBuilder.class, spec.getName().getPreferredName(), spec.getReader()));
    }

    private void registerFetchSubPhase(FetchSubPhase subPhase) {
        Class<?> subPhaseClass = subPhase.getClass();
        if (this.fetchSubPhases.stream().anyMatch(p -> p.getClass().equals(subPhaseClass))) {
            throw new IllegalArgumentException("FetchSubPhase [" + subPhaseClass + "] already registered");
        }
        this.fetchSubPhases.add(Objects.requireNonNull(subPhase, "FetchSubPhase must not be null"));
    }

    private void registerQueryParsers(List<SearchPlugin> plugins) {
        this.registerQuery(new SearchPlugin.QuerySpec<MatchQueryBuilder>("match", MatchQueryBuilder::new, MatchQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<MatchPhraseQueryBuilder>("match_phrase", MatchPhraseQueryBuilder::new, MatchPhraseQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<MatchPhrasePrefixQueryBuilder>("match_phrase_prefix", MatchPhrasePrefixQueryBuilder::new, MatchPhrasePrefixQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<MultiMatchQueryBuilder>("multi_match", MultiMatchQueryBuilder::new, MultiMatchQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<NestedQueryBuilder>("nested", NestedQueryBuilder::new, NestedQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<DisMaxQueryBuilder>("dis_max", DisMaxQueryBuilder::new, DisMaxQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<IdsQueryBuilder>("ids", IdsQueryBuilder::new, IdsQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<MatchAllQueryBuilder>("match_all", MatchAllQueryBuilder::new, MatchAllQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<QueryStringQueryBuilder>("query_string", QueryStringQueryBuilder::new, QueryStringQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<BoostingQueryBuilder>("boosting", BoostingQueryBuilder::new, BoostingQueryBuilder::fromXContent));
        BooleanQuery.setMaxClauseCount((int)INDICES_MAX_CLAUSE_COUNT_SETTING.get(this.settings));
        this.registerQuery(new SearchPlugin.QuerySpec<BoolQueryBuilder>("bool", BoolQueryBuilder::new, BoolQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<TermQueryBuilder>("term", TermQueryBuilder::new, TermQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<TermsQueryBuilder>("terms", TermsQueryBuilder::new, TermsQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<FuzzyQueryBuilder>("fuzzy", FuzzyQueryBuilder::new, FuzzyQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<RegexpQueryBuilder>("regexp", RegexpQueryBuilder::new, RegexpQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<RangeQueryBuilder>("range", RangeQueryBuilder::new, RangeQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<PrefixQueryBuilder>("prefix", PrefixQueryBuilder::new, PrefixQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<WildcardQueryBuilder>("wildcard", WildcardQueryBuilder::new, WildcardQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<ConstantScoreQueryBuilder>("constant_score", ConstantScoreQueryBuilder::new, ConstantScoreQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<SpanTermQueryBuilder>("span_term", SpanTermQueryBuilder::new, SpanTermQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<SpanNotQueryBuilder>("span_not", SpanNotQueryBuilder::new, SpanNotQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<SpanWithinQueryBuilder>("span_within", SpanWithinQueryBuilder::new, SpanWithinQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<SpanContainingQueryBuilder>("span_containing", SpanContainingQueryBuilder::new, SpanContainingQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<FieldMaskingSpanQueryBuilder>("field_masking_span", FieldMaskingSpanQueryBuilder::new, FieldMaskingSpanQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<SpanFirstQueryBuilder>("span_first", SpanFirstQueryBuilder::new, SpanFirstQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<SpanNearQueryBuilder>("span_near", SpanNearQueryBuilder::new, SpanNearQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<SpanNearQueryBuilder.SpanGapQueryBuilder>("span_gap", SpanNearQueryBuilder.SpanGapQueryBuilder::new, SpanNearQueryBuilder.SpanGapQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<SpanOrQueryBuilder>("span_or", SpanOrQueryBuilder::new, SpanOrQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<MoreLikeThisQueryBuilder>("more_like_this", MoreLikeThisQueryBuilder::new, MoreLikeThisQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<WrapperQueryBuilder>("wrapper", WrapperQueryBuilder::new, WrapperQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<CommonTermsQueryBuilder>(new ParseField("common", new String[0]).withAllDeprecated("[match] query which can efficiently skip blocks of documents if the total number of hits is not tracked"), CommonTermsQueryBuilder::new, CommonTermsQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<SpanMultiTermQueryBuilder>("span_multi", SpanMultiTermQueryBuilder::new, SpanMultiTermQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<FunctionScoreQueryBuilder>("function_score", FunctionScoreQueryBuilder::new, FunctionScoreQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<ScriptScoreQueryBuilder>("script_score", ScriptScoreQueryBuilder::new, ScriptScoreQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<SimpleQueryStringBuilder>("simple_query_string", SimpleQueryStringBuilder::new, SimpleQueryStringBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<TypeQueryBuilder>("type", TypeQueryBuilder::new, TypeQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<ScriptQueryBuilder>("script", ScriptQueryBuilder::new, ScriptQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<GeoDistanceQueryBuilder>("geo_distance", GeoDistanceQueryBuilder::new, GeoDistanceQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<GeoBoundingBoxQueryBuilder>("geo_bounding_box", GeoBoundingBoxQueryBuilder::new, GeoBoundingBoxQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<GeoPolygonQueryBuilder>("geo_polygon", GeoPolygonQueryBuilder::new, GeoPolygonQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<ExistsQueryBuilder>("exists", ExistsQueryBuilder::new, ExistsQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<MatchNoneQueryBuilder>("match_none", MatchNoneQueryBuilder::new, MatchNoneQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<TermsSetQueryBuilder>("terms_set", TermsSetQueryBuilder::new, TermsSetQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<IntervalQueryBuilder>("intervals", IntervalQueryBuilder::new, IntervalQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<DistanceFeatureQueryBuilder>("distance_feature", DistanceFeatureQueryBuilder::new, DistanceFeatureQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<MatchBoolPrefixQueryBuilder>("match_bool_prefix", MatchBoolPrefixQueryBuilder::new, MatchBoolPrefixQueryBuilder::fromXContent));
        if (ShapesAvailability.JTS_AVAILABLE && ShapesAvailability.SPATIAL4J_AVAILABLE) {
            this.registerQuery(new SearchPlugin.QuerySpec<GeoShapeQueryBuilder>("geo_shape", GeoShapeQueryBuilder::new, GeoShapeQueryBuilder::fromXContent));
        }
        this.registerFromPlugin(plugins, SearchPlugin::getQueries, this::registerQuery);
    }

    private void registerIntervalsSourceProviders() {
        this.namedWriteables.addAll(SearchModule.getIntervalsSourceProviderNamedWritables());
    }

    public static List<NamedWriteableRegistry.Entry> getIntervalsSourceProviderNamedWritables() {
        return Collections.unmodifiableList(Arrays.asList(new NamedWriteableRegistry.Entry(IntervalsSourceProvider.class, "match", IntervalsSourceProvider.Match::new), new NamedWriteableRegistry.Entry(IntervalsSourceProvider.class, "all_of", IntervalsSourceProvider.Combine::new), new NamedWriteableRegistry.Entry(IntervalsSourceProvider.class, "any_of", IntervalsSourceProvider.Disjunction::new), new NamedWriteableRegistry.Entry(IntervalsSourceProvider.class, "prefix", IntervalsSourceProvider.Prefix::new), new NamedWriteableRegistry.Entry(IntervalsSourceProvider.class, "wildcard", IntervalsSourceProvider.Wildcard::new), new NamedWriteableRegistry.Entry(IntervalsSourceProvider.class, "fuzzy", IntervalsSourceProvider.Fuzzy::new)));
    }

    private void registerQuery(SearchPlugin.QuerySpec<?> spec) {
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(QueryBuilder.class, spec.getName().getPreferredName(), spec.getReader()));
        this.namedXContents.add(new NamedXContentRegistry.Entry(QueryBuilder.class, spec.getName(), (p, c) -> ((QueryParser)spec.getParser()).fromXContent(p)));
    }

    public FetchPhase getFetchPhase() {
        return new FetchPhase(this.fetchSubPhases);
    }
}

