/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.easysearch.action.admin.indices.diskusage.AnalyzeIndexSpaceUsageAction;
import org.easysearch.action.admin.indices.diskusage.AnalyzeIndexSpaceUsageRequest;
import org.easysearch.action.support.IndicesOptions;
import org.easysearch.client.node.NodeClient;
import org.easysearch.common.Booleans;
import org.easysearch.common.Strings;
import org.easysearch.rest.BaseRestHandler;
import org.easysearch.rest.RestChannel;
import org.easysearch.rest.RestHandler;
import org.easysearch.rest.RestRequest;
import org.easysearch.rest.action.RestCancellableNodeClient;
import org.easysearch.rest.action.RestToXContentListener;

public class RestAnalyzeIndexSpaceUsageAction
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.POST, "/{index}/_disk_usage"));
    }

    @Override
    public String getName() {
        return "analyze_index_space_usage_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!Booleans.parseBoolean(request.param("run_expensive_tasks"), false)) {
            throw new IllegalArgumentException("analyzing the disk usage of an index is expensive and resource-intensive, the parameter [run_expensive_tasks] must be set to [true] in order for the task to be performed.");
        }
        String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        IndicesOptions indicesOptions = IndicesOptions.fromRequest(request, AnalyzeIndexSpaceUsageRequest.DEFAULT_INDICES_OPTIONS);
        boolean flush = request.paramAsBoolean("flush", true);
        AnalyzeIndexSpaceUsageRequest analyzeRequest = new AnalyzeIndexSpaceUsageRequest(indices, indicesOptions, flush);
        return channel -> {
            RestCancellableNodeClient cancelClient = new RestCancellableNodeClient(client, request.getHttpChannel());
            cancelClient.execute(AnalyzeIndexSpaceUsageAction.INSTANCE, analyzeRequest, new RestToXContentListener((RestChannel)channel));
        };
    }
}

