/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.rest.action;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.easysearch.action.ActionListener;
import org.easysearch.rest.BytesRestResponse;
import org.easysearch.rest.RestChannel;
import org.easysearch.rest.action.RestResponseListener;

public abstract class RestActionListener<Response>
implements ActionListener<Response> {
    private static Logger logger = LogManager.getLogger(RestResponseListener.class);
    protected final RestChannel channel;

    protected RestActionListener(RestChannel channel) {
        this.channel = channel;
    }

    @Override
    public final void onResponse(Response response) {
        try {
            this.processResponse(response);
        }
        catch (Exception e) {
            this.onFailure(e);
        }
    }

    protected abstract void processResponse(Response var1) throws Exception;

    @Override
    public final void onFailure(Exception e) {
        try {
            this.channel.sendResponse(new BytesRestResponse(this.channel, e));
        }
        catch (Exception inner) {
            inner.addSuppressed(e);
            logger.error("failed to send failure response", (Throwable)inner);
        }
    }
}

