/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.persistent;

import java.io.IOException;
import java.util.Objects;
import org.easysearch.action.ActionListener;
import org.easysearch.action.ActionRequestValidationException;
import org.easysearch.action.ActionType;
import org.easysearch.action.support.ActionFilters;
import org.easysearch.action.support.master.MasterNodeOperationRequestBuilder;
import org.easysearch.action.support.master.MasterNodeRequest;
import org.easysearch.action.support.master.TransportMasterNodeAction;
import org.easysearch.client.EasysearchClient;
import org.easysearch.cluster.ClusterState;
import org.easysearch.cluster.block.ClusterBlockException;
import org.easysearch.cluster.block.ClusterBlockLevel;
import org.easysearch.cluster.metadata.IndexNameExpressionResolver;
import org.easysearch.cluster.service.ClusterService;
import org.easysearch.common.inject.Inject;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.persistent.PersistentTaskResponse;
import org.easysearch.persistent.PersistentTasksClusterService;
import org.easysearch.persistent.PersistentTasksCustomMetadata;
import org.easysearch.threadpool.ThreadPool;
import org.easysearch.transport.TransportService;

public class RemovePersistentTaskAction
extends ActionType<PersistentTaskResponse> {
    public static final RemovePersistentTaskAction INSTANCE = new RemovePersistentTaskAction();
    public static final String NAME = "cluster:admin/persistent/remove";

    private RemovePersistentTaskAction() {
        super(NAME, PersistentTaskResponse::new);
    }

    public static class TransportAction
    extends TransportMasterNodeAction<Request, PersistentTaskResponse> {
        private final PersistentTasksClusterService persistentTasksClusterService;

        @Inject
        public TransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, PersistentTasksClusterService persistentTasksClusterService, IndexNameExpressionResolver indexNameExpressionResolver) {
            super(RemovePersistentTaskAction.NAME, transportService, clusterService, threadPool, actionFilters, Request::new, indexNameExpressionResolver);
            this.persistentTasksClusterService = persistentTasksClusterService;
        }

        @Override
        protected String executor() {
            return "management";
        }

        @Override
        protected PersistentTaskResponse read(StreamInput in) throws IOException {
            return new PersistentTaskResponse(in);
        }

        @Override
        protected ClusterBlockException checkBlock(Request request, ClusterState state) {
            return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
        }

        @Override
        protected final void masterOperation(Request request, ClusterState state, ActionListener<PersistentTaskResponse> listener) {
            this.persistentTasksClusterService.removePersistentTask(request.taskId, ActionListener.delegateFailure(listener, (delegatedListener, task) -> delegatedListener.onResponse(new PersistentTaskResponse((PersistentTasksCustomMetadata.PersistentTask<?>)task))));
        }
    }

    public static class RequestBuilder
    extends MasterNodeOperationRequestBuilder<Request, PersistentTaskResponse, RequestBuilder> {
        protected RequestBuilder(EasysearchClient client, RemovePersistentTaskAction action) {
            super(client, action, new Request());
        }

        public final RequestBuilder setTaskId(String taskId) {
            ((Request)this.request).setTaskId(taskId);
            return this;
        }
    }

    public static class Request
    extends MasterNodeRequest<Request> {
        private String taskId;

        public Request() {
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.taskId = in.readString();
        }

        public Request(String taskId) {
            this.taskId = taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.taskId);
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Objects.equals(this.taskId, request.taskId);
        }

        public int hashCode() {
            return Objects.hash(this.taskId);
        }
    }
}

