/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.persistent;

import java.util.Map;
import java.util.function.Predicate;
import org.easysearch.cluster.ClusterState;
import org.easysearch.cluster.node.DiscoveryNode;
import org.easysearch.common.Nullable;
import org.easysearch.persistent.AllocatedPersistentTask;
import org.easysearch.persistent.PersistentTaskParams;
import org.easysearch.persistent.PersistentTaskState;
import org.easysearch.persistent.PersistentTasksCustomMetadata;
import org.easysearch.tasks.TaskId;

public abstract class PersistentTasksExecutor<Params extends PersistentTaskParams> {
    private final String executor;
    private final String taskName;
    public static final PersistentTasksCustomMetadata.Assignment NO_NODE_FOUND = new PersistentTasksCustomMetadata.Assignment(null, "no appropriate nodes found for the assignment");

    protected PersistentTasksExecutor(String taskName, String executor) {
        this.taskName = taskName;
        this.executor = executor;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public PersistentTasksCustomMetadata.Assignment getAssignment(Params params, ClusterState clusterState) {
        DiscoveryNode discoveryNode = this.selectLeastLoadedNode(clusterState, DiscoveryNode::isDataNode);
        if (discoveryNode == null) {
            return NO_NODE_FOUND;
        }
        return new PersistentTasksCustomMetadata.Assignment(discoveryNode.getId(), "");
    }

    protected DiscoveryNode selectLeastLoadedNode(ClusterState clusterState, Predicate<DiscoveryNode> selector) {
        long minLoad = Long.MAX_VALUE;
        DiscoveryNode minLoadedNode = null;
        PersistentTasksCustomMetadata persistentTasks = (PersistentTasksCustomMetadata)clusterState.getMetadata().custom("persistent_tasks");
        for (DiscoveryNode node : clusterState.getNodes()) {
            if (!selector.test(node)) continue;
            if (persistentTasks == null) {
                return node;
            }
            long numberOfTasks = persistentTasks.getNumberOfTasksOnNode(node.getId(), this.taskName);
            if (minLoad <= numberOfTasks) continue;
            minLoad = numberOfTasks;
            minLoadedNode = node;
        }
        return minLoadedNode;
    }

    public void validate(Params params, ClusterState clusterState) {
    }

    protected AllocatedPersistentTask createTask(long id, String type, String action, TaskId parentTaskId, PersistentTasksCustomMetadata.PersistentTask<Params> taskInProgress, Map<String, String> headers) {
        return new AllocatedPersistentTask(id, type, action, this.getDescription(taskInProgress), parentTaskId, headers);
    }

    protected String getDescription(PersistentTasksCustomMetadata.PersistentTask<Params> taskInProgress) {
        return "id=" + taskInProgress.getId();
    }

    protected abstract void nodeOperation(AllocatedPersistentTask var1, Params var2, @Nullable PersistentTaskState var3);

    public String getExecutor() {
        return this.executor;
    }
}

