/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.monitor.jvm;

import java.lang.management.ManagementFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;

class JvmPid {
    private static final long PID = JvmPid.initializePid();

    JvmPid() {
    }

    static long getPid() {
        return PID;
    }

    private static long initializePid() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        try {
            return Long.parseLong(name.split("@")[0]);
        }
        catch (NumberFormatException e) {
            LogManager.getLogger(JvmPid.class).debug((Message)new ParameterizedMessage("failed parsing PID from [{}]", (Object)name), (Throwable)e);
            return -1L;
        }
    }
}

