/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.ingest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import org.easysearch.EasysearchException;
import org.easysearch.common.collect.Tuple;
import org.easysearch.ingest.IngestDocument;
import org.easysearch.ingest.IngestMetric;
import org.easysearch.ingest.IngestProcessorException;
import org.easysearch.ingest.Processor;

public class CompoundProcessor
implements Processor {
    public static final String ON_FAILURE_MESSAGE_FIELD = "on_failure_message";
    public static final String ON_FAILURE_PROCESSOR_TYPE_FIELD = "on_failure_processor_type";
    public static final String ON_FAILURE_PROCESSOR_TAG_FIELD = "on_failure_processor_tag";
    public static final String ON_FAILURE_PIPELINE_FIELD = "on_failure_pipeline";
    private final boolean ignoreFailure;
    private final List<Processor> processors;
    private final List<Processor> onFailureProcessors;
    private final List<Tuple<Processor, IngestMetric>> processorsWithMetrics;
    private final LongSupplier relativeTimeProvider;

    CompoundProcessor(LongSupplier relativeTimeProvider, Processor ... processor) {
        this(false, Arrays.asList(processor), Collections.emptyList(), relativeTimeProvider);
    }

    public CompoundProcessor(Processor ... processor) {
        this(false, Arrays.asList(processor), Collections.emptyList());
    }

    public CompoundProcessor(boolean ignoreFailure, List<Processor> processors, List<Processor> onFailureProcessors) {
        this(ignoreFailure, processors, onFailureProcessors, System::nanoTime);
    }

    CompoundProcessor(boolean ignoreFailure, List<Processor> processors, List<Processor> onFailureProcessors, LongSupplier relativeTimeProvider) {
        this.ignoreFailure = ignoreFailure;
        this.processors = processors;
        this.onFailureProcessors = onFailureProcessors;
        this.relativeTimeProvider = relativeTimeProvider;
        this.processorsWithMetrics = new ArrayList<Tuple<Processor, IngestMetric>>(processors.size());
        processors.forEach(p -> this.processorsWithMetrics.add(new Tuple<Processor, IngestMetric>((Processor)p, new IngestMetric())));
    }

    List<Tuple<Processor, IngestMetric>> getProcessorsWithMetrics() {
        return this.processorsWithMetrics;
    }

    public boolean isIgnoreFailure() {
        return this.ignoreFailure;
    }

    public List<Processor> getOnFailureProcessors() {
        return this.onFailureProcessors;
    }

    public List<Processor> getProcessors() {
        return this.processors;
    }

    public List<Processor> flattenProcessors() {
        ArrayList<Processor> allProcessors = new ArrayList<Processor>(CompoundProcessor.flattenProcessors(this.processors));
        allProcessors.addAll(CompoundProcessor.flattenProcessors(this.onFailureProcessors));
        return allProcessors;
    }

    private static List<Processor> flattenProcessors(List<Processor> processors) {
        ArrayList<Processor> flattened = new ArrayList<Processor>();
        for (Processor processor : processors) {
            if (processor instanceof CompoundProcessor) {
                flattened.addAll(((CompoundProcessor)processor).flattenProcessors());
                continue;
            }
            flattened.add(processor);
        }
        return flattened;
    }

    @Override
    public String getType() {
        return "compound";
    }

    @Override
    public String getTag() {
        return "CompoundProcessor-" + this.flattenProcessors().stream().map(Processor::getTag).collect(Collectors.joining("-"));
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public IngestDocument execute(IngestDocument ingestDocument) throws Exception {
        throw new UnsupportedOperationException("this method should not get executed");
    }

    @Override
    public void execute(IngestDocument ingestDocument, BiConsumer<IngestDocument, Exception> handler) {
        this.innerExecute(0, ingestDocument, handler);
    }

    void innerExecute(int currentProcessor, IngestDocument ingestDocument, BiConsumer<IngestDocument, Exception> handler) {
        if (currentProcessor == this.processorsWithMetrics.size()) {
            handler.accept(ingestDocument, null);
            return;
        }
        Tuple<Processor, IngestMetric> processorWithMetric = this.processorsWithMetrics.get(currentProcessor);
        Processor processor = processorWithMetric.v1();
        IngestMetric metric = processorWithMetric.v2();
        long startTimeInNanos = this.relativeTimeProvider.getAsLong();
        metric.preIngest();
        processor.execute(ingestDocument, (result, e) -> {
            long ingestTimeInMillis = TimeUnit.NANOSECONDS.toMillis(this.relativeTimeProvider.getAsLong() - startTimeInNanos);
            metric.postIngest(ingestTimeInMillis);
            if (e != null) {
                metric.ingestFailed();
                if (this.ignoreFailure) {
                    this.innerExecute(currentProcessor + 1, ingestDocument, handler);
                } else {
                    IngestProcessorException compoundProcessorException = CompoundProcessor.newCompoundProcessorException(e, processor, ingestDocument);
                    if (this.onFailureProcessors.isEmpty()) {
                        handler.accept(null, compoundProcessorException);
                    } else {
                        this.executeOnFailureAsync(0, ingestDocument, compoundProcessorException, handler);
                    }
                }
            } else if (result != null) {
                this.innerExecute(currentProcessor + 1, (IngestDocument)result, handler);
            } else {
                handler.accept(null, null);
            }
        });
    }

    void executeOnFailureAsync(int currentOnFailureProcessor, IngestDocument ingestDocument, EasysearchException exception, BiConsumer<IngestDocument, Exception> handler) {
        if (currentOnFailureProcessor == 0) {
            this.putFailureMetadata(ingestDocument, exception);
        }
        if (currentOnFailureProcessor == this.onFailureProcessors.size()) {
            this.removeFailureMetadata(ingestDocument);
            handler.accept(ingestDocument, null);
            return;
        }
        Processor onFailureProcessor = this.onFailureProcessors.get(currentOnFailureProcessor);
        onFailureProcessor.execute(ingestDocument, (result, e) -> {
            if (e != null) {
                this.removeFailureMetadata(ingestDocument);
                handler.accept(null, CompoundProcessor.newCompoundProcessorException(e, onFailureProcessor, ingestDocument));
                return;
            }
            if (result == null) {
                this.removeFailureMetadata(ingestDocument);
                handler.accept(null, null);
                return;
            }
            this.executeOnFailureAsync(currentOnFailureProcessor + 1, ingestDocument, exception, handler);
        });
    }

    private void putFailureMetadata(IngestDocument ingestDocument, EasysearchException cause) {
        List<String> processorTypeHeader = cause.getHeader("processor_type");
        List<String> processorTagHeader = cause.getHeader("processor_tag");
        List<String> processorOriginHeader = cause.getHeader("pipeline_origin");
        String failedProcessorType = processorTypeHeader != null ? processorTypeHeader.get(0) : null;
        String failedProcessorTag = processorTagHeader != null ? processorTagHeader.get(0) : null;
        String failedPipelineId = processorOriginHeader != null ? processorOriginHeader.get(0) : null;
        Map<String, Object> ingestMetadata = ingestDocument.getIngestMetadata();
        ingestMetadata.put(ON_FAILURE_MESSAGE_FIELD, cause.getRootCause().getMessage());
        ingestMetadata.put(ON_FAILURE_PROCESSOR_TYPE_FIELD, failedProcessorType);
        ingestMetadata.put(ON_FAILURE_PROCESSOR_TAG_FIELD, failedProcessorTag);
        if (failedPipelineId != null) {
            ingestMetadata.put(ON_FAILURE_PIPELINE_FIELD, failedPipelineId);
        }
    }

    private void removeFailureMetadata(IngestDocument ingestDocument) {
        Map<String, Object> ingestMetadata = ingestDocument.getIngestMetadata();
        ingestMetadata.remove(ON_FAILURE_MESSAGE_FIELD);
        ingestMetadata.remove(ON_FAILURE_PROCESSOR_TYPE_FIELD);
        ingestMetadata.remove(ON_FAILURE_PROCESSOR_TAG_FIELD);
        ingestMetadata.remove(ON_FAILURE_PIPELINE_FIELD);
    }

    static IngestProcessorException newCompoundProcessorException(Exception e, Processor processor, IngestDocument document) {
        List<String> pipelineStack;
        String processorTag;
        if (e instanceof IngestProcessorException && ((IngestProcessorException)e).getHeader("processor_type") != null) {
            return (IngestProcessorException)e;
        }
        IngestProcessorException exception = new IngestProcessorException(e);
        String processorType = processor.getType();
        if (processorType != null) {
            exception.addHeader("processor_type", processorType);
        }
        if ((processorTag = processor.getTag()) != null) {
            exception.addHeader("processor_tag", processorTag);
        }
        if ((pipelineStack = document.getPipelineStack()).size() > 1) {
            exception.addHeader("pipeline_origin", pipelineStack);
        }
        return exception;
    }
}

