/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.indices.recovery;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.store.RateLimiter;
import org.easysearch.EasysearchException;
import org.easysearch.ExceptionsHelper;
import org.easysearch.action.ActionListener;
import org.easysearch.action.ActionListenerResponseHandler;
import org.easysearch.action.support.RetryableAction;
import org.easysearch.cluster.node.DiscoveryNode;
import org.easysearch.common.breaker.CircuitBreakingException;
import org.easysearch.common.bytes.BytesReference;
import org.easysearch.common.io.stream.Writeable;
import org.easysearch.common.unit.TimeValue;
import org.easysearch.common.util.CancellableThreads;
import org.easysearch.common.util.concurrent.ConcurrentCollections;
import org.easysearch.common.util.concurrent.EsRejectedExecutionException;
import org.easysearch.index.seqno.ReplicationTracker;
import org.easysearch.index.seqno.RetentionLeases;
import org.easysearch.index.shard.ShardId;
import org.easysearch.index.store.Store;
import org.easysearch.index.store.StoreFileMetadata;
import org.easysearch.index.translog.Translog;
import org.easysearch.indices.recovery.RecoveryCleanFilesRequest;
import org.easysearch.indices.recovery.RecoveryFileChunkRequest;
import org.easysearch.indices.recovery.RecoveryFilesInfoRequest;
import org.easysearch.indices.recovery.RecoveryFinalizeRecoveryRequest;
import org.easysearch.indices.recovery.RecoveryHandoffPrimaryContextRequest;
import org.easysearch.indices.recovery.RecoveryPrepareForTranslogOperationsRequest;
import org.easysearch.indices.recovery.RecoverySettings;
import org.easysearch.indices.recovery.RecoveryTargetHandler;
import org.easysearch.indices.recovery.RecoveryTranslogOperationsRequest;
import org.easysearch.indices.recovery.RecoveryTranslogOperationsResponse;
import org.easysearch.indices.recovery.RecoveryTransportRequest;
import org.easysearch.threadpool.ThreadPool;
import org.easysearch.transport.ConnectTransportException;
import org.easysearch.transport.EmptyTransportResponseHandler;
import org.easysearch.transport.RemoteTransportException;
import org.easysearch.transport.SendRequestTransportException;
import org.easysearch.transport.TransportRequest;
import org.easysearch.transport.TransportRequestOptions;
import org.easysearch.transport.TransportResponse;
import org.easysearch.transport.TransportService;

public class RemoteRecoveryTargetHandler
implements RecoveryTargetHandler {
    private static final Logger logger = LogManager.getLogger(RemoteRecoveryTargetHandler.class);
    private final TransportService transportService;
    private final ThreadPool threadPool;
    private final long recoveryId;
    private final ShardId shardId;
    private final DiscoveryNode targetNode;
    private final RecoverySettings recoverySettings;
    private final Map<Object, RetryableAction<?>> onGoingRetryableActions = ConcurrentCollections.newConcurrentMap();
    private final TransportRequestOptions translogOpsRequestOptions;
    private final TransportRequestOptions fileChunkRequestOptions;
    private final AtomicLong bytesSinceLastPause = new AtomicLong();
    private final AtomicLong requestSeqNoGenerator = new AtomicLong(0L);
    private final Consumer<Long> onSourceThrottle;
    private final boolean retriesSupported;
    private volatile boolean isCancelled = false;

    public RemoteRecoveryTargetHandler(long recoveryId, ShardId shardId, TransportService transportService, DiscoveryNode targetNode, RecoverySettings recoverySettings, Consumer<Long> onSourceThrottle) {
        this.transportService = transportService;
        this.threadPool = transportService.getThreadPool();
        this.recoveryId = recoveryId;
        this.shardId = shardId;
        this.targetNode = targetNode;
        this.recoverySettings = recoverySettings;
        this.onSourceThrottle = onSourceThrottle;
        this.translogOpsRequestOptions = TransportRequestOptions.builder().withType(TransportRequestOptions.Type.RECOVERY).withTimeout(recoverySettings.internalActionLongTimeout()).build();
        this.fileChunkRequestOptions = TransportRequestOptions.builder().withType(TransportRequestOptions.Type.RECOVERY).withTimeout(recoverySettings.internalActionTimeout()).build();
        this.retriesSupported = true;
    }

    public DiscoveryNode targetNode() {
        return this.targetNode;
    }

    @Override
    public void prepareForTranslogOperations(int totalTranslogOps, ActionListener<Void> listener) {
        String action = "internal:index/shard/recovery/prepare_translog";
        long requestSeqNo = this.requestSeqNoGenerator.getAndIncrement();
        RecoveryPrepareForTranslogOperationsRequest request = new RecoveryPrepareForTranslogOperationsRequest(this.recoveryId, requestSeqNo, this.shardId, totalTranslogOps);
        TransportRequestOptions options = TransportRequestOptions.builder().withTimeout(this.recoverySettings.internalActionTimeout()).build();
        Writeable.Reader<TransportResponse.Empty> reader = in -> TransportResponse.Empty.INSTANCE;
        ActionListener<TransportResponse.Empty> responseListener = ActionListener.map(listener, r -> null);
        this.executeRetryableAction("internal:index/shard/recovery/prepare_translog", request, options, responseListener, reader);
    }

    @Override
    public void finalizeRecovery(long globalCheckpoint, long trimAboveSeqNo, ActionListener<Void> listener) {
        String action = "internal:index/shard/recovery/finalize";
        long requestSeqNo = this.requestSeqNoGenerator.getAndIncrement();
        RecoveryFinalizeRecoveryRequest request = new RecoveryFinalizeRecoveryRequest(this.recoveryId, requestSeqNo, this.shardId, globalCheckpoint, trimAboveSeqNo);
        TransportRequestOptions options = TransportRequestOptions.builder().withTimeout(this.recoverySettings.internalActionLongTimeout()).build();
        Writeable.Reader<TransportResponse.Empty> reader = in -> TransportResponse.Empty.INSTANCE;
        ActionListener<TransportResponse.Empty> responseListener = ActionListener.map(listener, r -> null);
        this.executeRetryableAction("internal:index/shard/recovery/finalize", request, options, responseListener, reader);
    }

    @Override
    public void handoffPrimaryContext(ReplicationTracker.PrimaryContext primaryContext) {
        this.transportService.submitRequest(this.targetNode, "internal:index/shard/recovery/handoff_primary_context", new RecoveryHandoffPrimaryContextRequest(this.recoveryId, this.shardId, primaryContext), TransportRequestOptions.builder().withTimeout(this.recoverySettings.internalActionTimeout()).build(), EmptyTransportResponseHandler.INSTANCE_SAME).txGet();
    }

    @Override
    public void indexTranslogOperations(List<Translog.Operation> operations, int totalTranslogOps, long maxSeenAutoIdTimestampOnPrimary, long maxSeqNoOfDeletesOrUpdatesOnPrimary, RetentionLeases retentionLeases, long mappingVersionOnPrimary, ActionListener<Long> listener) {
        String action = "internal:index/shard/recovery/translog_ops";
        long requestSeqNo = this.requestSeqNoGenerator.getAndIncrement();
        RecoveryTranslogOperationsRequest request = new RecoveryTranslogOperationsRequest(this.recoveryId, requestSeqNo, this.shardId, operations, totalTranslogOps, maxSeenAutoIdTimestampOnPrimary, maxSeqNoOfDeletesOrUpdatesOnPrimary, retentionLeases, mappingVersionOnPrimary);
        Writeable.Reader<RecoveryTranslogOperationsResponse> reader = RecoveryTranslogOperationsResponse::new;
        ActionListener<RecoveryTranslogOperationsResponse> responseListener = ActionListener.map(listener, r -> r.localCheckpoint);
        this.executeRetryableAction("internal:index/shard/recovery/translog_ops", request, this.translogOpsRequestOptions, responseListener, reader);
    }

    @Override
    public void receiveFileInfo(List<String> phase1FileNames, List<Long> phase1FileSizes, List<String> phase1ExistingFileNames, List<Long> phase1ExistingFileSizes, int totalTranslogOps, ActionListener<Void> listener) {
        String action = "internal:index/shard/recovery/filesInfo";
        long requestSeqNo = this.requestSeqNoGenerator.getAndIncrement();
        RecoveryFilesInfoRequest request = new RecoveryFilesInfoRequest(this.recoveryId, requestSeqNo, this.shardId, phase1FileNames, phase1FileSizes, phase1ExistingFileNames, phase1ExistingFileSizes, totalTranslogOps);
        TransportRequestOptions options = TransportRequestOptions.builder().withTimeout(this.recoverySettings.internalActionTimeout()).build();
        Writeable.Reader<TransportResponse.Empty> reader = in -> TransportResponse.Empty.INSTANCE;
        ActionListener<TransportResponse.Empty> responseListener = ActionListener.map(listener, r -> null);
        this.executeRetryableAction("internal:index/shard/recovery/filesInfo", request, options, responseListener, reader);
    }

    @Override
    public void cleanFiles(int totalTranslogOps, long globalCheckpoint, Store.MetadataSnapshot sourceMetadata, ActionListener<Void> listener) {
        String action = "internal:index/shard/recovery/clean_files";
        long requestSeqNo = this.requestSeqNoGenerator.getAndIncrement();
        RecoveryCleanFilesRequest request = new RecoveryCleanFilesRequest(this.recoveryId, requestSeqNo, this.shardId, sourceMetadata, totalTranslogOps, globalCheckpoint);
        TransportRequestOptions options = TransportRequestOptions.builder().withTimeout(this.recoverySettings.internalActionTimeout()).build();
        Writeable.Reader<TransportResponse.Empty> reader = in -> TransportResponse.Empty.INSTANCE;
        ActionListener<TransportResponse.Empty> responseListener = ActionListener.map(listener, r -> null);
        this.executeRetryableAction("internal:index/shard/recovery/clean_files", request, options, responseListener, reader);
    }

    @Override
    public void writeFileChunk(StoreFileMetadata fileMetadata, long position, BytesReference content, boolean lastChunk, int totalTranslogOps, ActionListener<Void> listener) {
        long throttleTimeInNanos;
        RateLimiter rl = this.recoverySettings.rateLimiter();
        if (rl != null) {
            long bytes = this.bytesSinceLastPause.addAndGet(content.length());
            if (bytes > rl.getMinPauseCheckBytes()) {
                this.bytesSinceLastPause.addAndGet(-bytes);
                try {
                    throttleTimeInNanos = rl.pause(bytes);
                    this.onSourceThrottle.accept(throttleTimeInNanos);
                }
                catch (IOException e) {
                    throw new EasysearchException("failed to pause recovery", (Throwable)e, new Object[0]);
                }
            } else {
                throttleTimeInNanos = 0L;
            }
        } else {
            throttleTimeInNanos = 0L;
        }
        String action = "internal:index/shard/recovery/file_chunk";
        long requestSeqNo = this.requestSeqNoGenerator.getAndIncrement();
        RecoveryFileChunkRequest request = new RecoveryFileChunkRequest(this.recoveryId, requestSeqNo, this.shardId, fileMetadata, position, content, lastChunk, totalTranslogOps, throttleTimeInNanos);
        Writeable.Reader<TransportResponse.Empty> reader = in -> TransportResponse.Empty.INSTANCE;
        this.executeRetryableAction("internal:index/shard/recovery/file_chunk", request, this.fileChunkRequestOptions, ActionListener.map(listener, r -> null), reader);
    }

    @Override
    public void cancel() {
        this.isCancelled = true;
        if (this.onGoingRetryableActions.isEmpty()) {
            return;
        }
        CancellableThreads.ExecutionCancelledException exception = new CancellableThreads.ExecutionCancelledException("recovery was cancelled");
        this.threadPool.generic().execute(() -> {
            for (RetryableAction<?> action : this.onGoingRetryableActions.values()) {
                action.cancel(exception);
            }
            this.onGoingRetryableActions.clear();
        });
    }

    private <T extends TransportResponse> void executeRetryableAction(final String action, final RecoveryTransportRequest request, final TransportRequestOptions options, ActionListener<T> actionListener, final Writeable.Reader<T> reader) {
        Object key = new Object();
        ActionListener<T> removeListener = ActionListener.runBefore(actionListener, () -> this.onGoingRetryableActions.remove(key));
        TimeValue initialDelay = TimeValue.timeValueMillis(200L);
        TimeValue timeout = this.recoverySettings.internalActionRetryTimeout();
        RetryableAction retryableAction = new RetryableAction<T>(logger, this.threadPool, initialDelay, timeout, removeListener){

            @Override
            public void tryAction(ActionListener<T> listener) {
                RemoteRecoveryTargetHandler.this.transportService.sendRequest(RemoteRecoveryTargetHandler.this.targetNode, action, (TransportRequest)request, options, new ActionListenerResponseHandler(listener, reader, "generic"));
            }

            @Override
            public boolean shouldRetry(Exception e) {
                return RemoteRecoveryTargetHandler.this.retriesSupported && RemoteRecoveryTargetHandler.retryableException(e);
            }
        };
        this.onGoingRetryableActions.put(key, retryableAction);
        retryableAction.run();
        if (this.isCancelled) {
            retryableAction.cancel(new CancellableThreads.ExecutionCancelledException("recovery was cancelled"));
        }
    }

    private static boolean retryableException(Exception e) {
        if (e instanceof ConnectTransportException) {
            return true;
        }
        if (e instanceof SendRequestTransportException) {
            Throwable cause = ExceptionsHelper.unwrapCause(e);
            return cause instanceof ConnectTransportException;
        }
        if (e instanceof RemoteTransportException) {
            Throwable cause = ExceptionsHelper.unwrapCause(e);
            return cause instanceof CircuitBreakingException || cause instanceof EsRejectedExecutionException;
        }
        return false;
    }
}

