/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.index.warmer;

import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.easysearch.common.metrics.CounterMetric;
import org.easysearch.common.metrics.MeanMetric;
import org.easysearch.index.IndexSettings;
import org.easysearch.index.shard.AbstractIndexShardComponent;
import org.easysearch.index.shard.ShardId;
import org.easysearch.index.warmer.WarmerStats;

public class ShardIndexWarmerService
extends AbstractIndexShardComponent {
    private final CounterMetric current = new CounterMetric();
    private final MeanMetric warmerMetric = new MeanMetric();

    public ShardIndexWarmerService(ShardId shardId, IndexSettings indexSettings) {
        super(shardId, indexSettings);
    }

    public Logger logger() {
        return this.logger;
    }

    public void onPreWarm() {
        this.current.inc();
    }

    public void onPostWarm(long tookInNanos) {
        this.current.dec();
        this.warmerMetric.inc(tookInNanos);
    }

    public WarmerStats stats() {
        return new WarmerStats(this.current.count(), this.warmerMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.warmerMetric.sum()));
    }
}

