/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.index.shard;

import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.LeafReader;
import org.easysearch.common.Nullable;
import org.easysearch.common.lucene.index.EasysearchDirectoryReader;
import org.easysearch.common.lucene.index.EasysearchLeafReader;
import org.easysearch.index.shard.ShardId;

public final class ShardUtils {
    private ShardUtils() {
    }

    @Nullable
    public static ShardId extractShardId(LeafReader reader) {
        EasysearchLeafReader esReader = EasysearchLeafReader.getEasysearchLeafReader(reader);
        if (esReader != null) {
            assert (reader.getRefCount() > 0) : "EasysearchLeafReader is already closed";
            return esReader.shardId();
        }
        return null;
    }

    @Nullable
    public static ShardId extractShardId(DirectoryReader reader) {
        EasysearchDirectoryReader esReader = EasysearchDirectoryReader.getEasysearchDirectoryReader(reader);
        if (esReader != null) {
            return esReader.shardId();
        }
        throw new IllegalArgumentException("can't extract shard ID, can't unwrap EasysearchDirectoryReader");
    }
}

