/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.index.query.functionscore;

import java.io.IOException;
import org.apache.lucene.search.Explanation;
import org.easysearch.common.ParseField;
import org.easysearch.common.bytes.BytesReference;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.index.query.functionscore.DecayFunction;
import org.easysearch.index.query.functionscore.DecayFunctionBuilder;
import org.easysearch.index.query.functionscore.DecayFunctionParser;
import org.easysearch.index.query.functionscore.ScoreFunctionParser;

public class GaussDecayFunctionBuilder
extends DecayFunctionBuilder<GaussDecayFunctionBuilder> {
    public static final String NAME = "gauss";
    public static final ParseField FUNCTION_NAME_FIELD = new ParseField("gauss", new String[0]);
    public static final ScoreFunctionParser<GaussDecayFunctionBuilder> PARSER = new DecayFunctionParser<GaussDecayFunctionBuilder>(GaussDecayFunctionBuilder::new);
    public static final DecayFunction GAUSS_DECAY_FUNCTION = new GaussScoreFunction();

    public GaussDecayFunctionBuilder(String fieldName, Object origin, Object scale, Object offset) {
        super(fieldName, origin, scale, offset);
    }

    public GaussDecayFunctionBuilder(String fieldName, Object origin, Object scale, Object offset, double decay) {
        super(fieldName, origin, scale, offset, decay);
    }

    GaussDecayFunctionBuilder(String fieldName, BytesReference functionBytes) {
        super(fieldName, functionBytes);
    }

    public GaussDecayFunctionBuilder(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public DecayFunction getDecayFunction() {
        return GAUSS_DECAY_FUNCTION;
    }

    private static final class GaussScoreFunction
    implements DecayFunction {
        private GaussScoreFunction() {
        }

        @Override
        public double evaluate(double value, double scale) {
            return Math.exp(0.5 * Math.pow(value, 2.0) / scale);
        }

        @Override
        public Explanation explainFunction(String valueExpl, double value, double scale) {
            return Explanation.match((Number)Float.valueOf((float)this.evaluate(value, scale)), (String)("exp(-0.5*pow(" + valueExpl + ",2.0)/" + -1.0 * scale + ")"), (Explanation[])new Explanation[0]);
        }

        @Override
        public double processScale(double scale, double decay) {
            return 0.5 * Math.pow(scale, 2.0) / Math.log(decay);
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        public boolean equals(Object obj) {
            if (super.equals(obj)) {
                return true;
            }
            return obj != null && this.getClass() != obj.getClass();
        }
    }
}

