/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.index.query.functionscore;

import java.io.IOException;
import org.apache.lucene.search.Explanation;
import org.easysearch.common.bytes.BytesReference;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.index.query.functionscore.DecayFunction;
import org.easysearch.index.query.functionscore.DecayFunctionBuilder;
import org.easysearch.index.query.functionscore.DecayFunctionParser;
import org.easysearch.index.query.functionscore.ScoreFunctionParser;

public class ExponentialDecayFunctionBuilder
extends DecayFunctionBuilder<ExponentialDecayFunctionBuilder> {
    public static final String NAME = "exp";
    public static final ScoreFunctionParser<ExponentialDecayFunctionBuilder> PARSER = new DecayFunctionParser<ExponentialDecayFunctionBuilder>(ExponentialDecayFunctionBuilder::new);
    public static final DecayFunction EXP_DECAY_FUNCTION = new ExponentialDecayScoreFunction();

    public ExponentialDecayFunctionBuilder(String fieldName, Object origin, Object scale, Object offset) {
        super(fieldName, origin, scale, offset);
    }

    public ExponentialDecayFunctionBuilder(String fieldName, Object origin, Object scale, Object offset, double decay) {
        super(fieldName, origin, scale, offset, decay);
    }

    ExponentialDecayFunctionBuilder(String fieldName, BytesReference functionBytes) {
        super(fieldName, functionBytes);
    }

    public ExponentialDecayFunctionBuilder(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public DecayFunction getDecayFunction() {
        return EXP_DECAY_FUNCTION;
    }

    private static final class ExponentialDecayScoreFunction
    implements DecayFunction {
        private ExponentialDecayScoreFunction() {
        }

        @Override
        public double evaluate(double value, double scale) {
            return Math.exp(scale * value);
        }

        @Override
        public Explanation explainFunction(String valueExpl, double value, double scale) {
            return Explanation.match((Number)Float.valueOf((float)this.evaluate(value, scale)), (String)("exp(- " + valueExpl + " * " + -1.0 * scale + ")"), (Explanation[])new Explanation[0]);
        }

        @Override
        public double processScale(double scale, double decay) {
            return Math.log(decay) / scale;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        public boolean equals(Object obj) {
            if (super.equals(obj)) {
                return true;
            }
            return obj != null && this.getClass() != obj.getClass();
        }
    }
}

