/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.index.mapper;

import java.util.Objects;
import org.easysearch.common.Nullable;
import org.easysearch.common.bytes.BytesArray;
import org.easysearch.common.bytes.BytesReference;
import org.easysearch.common.xcontent.XContentType;

public class SourceToParse {
    private final BytesReference source;
    private final String index;
    private final String type;
    private final String id;
    @Nullable
    private final String routing;
    private final XContentType xContentType;

    public SourceToParse(String index, String type, String id, BytesReference source, XContentType xContentType, @Nullable String routing) {
        this.index = Objects.requireNonNull(index);
        this.type = Objects.requireNonNull(type);
        this.id = Objects.requireNonNull(id);
        this.source = new BytesArray(Objects.requireNonNull(source).toBytesRef());
        this.xContentType = Objects.requireNonNull(xContentType);
        this.routing = routing;
    }

    public SourceToParse(String index, String type, String id, BytesReference source, XContentType xContentType) {
        this(index, type, id, source, xContentType, null);
    }

    public BytesReference source() {
        return this.source;
    }

    public String index() {
        return this.index;
    }

    public String type() {
        return this.type;
    }

    public String id() {
        return this.id;
    }

    @Nullable
    public String routing() {
        return this.routing;
    }

    public XContentType getXContentType() {
        return this.xContentType;
    }

    public static enum Origin {
        PRIMARY,
        REPLICA;

    }
}

