/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.index.mapper;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.FieldType;
import org.easysearch.common.Explicit;
import org.easysearch.common.ParseField;
import org.easysearch.common.geo.builders.ShapeBuilder;
import org.easysearch.common.xcontent.LoggingDeprecationHandler;
import org.easysearch.common.xcontent.ToXContent;
import org.easysearch.common.xcontent.XContentBuilder;
import org.easysearch.common.xcontent.support.XContentMapValues;
import org.easysearch.index.mapper.AbstractGeometryFieldMapper;
import org.easysearch.index.mapper.FieldMapper;
import org.easysearch.index.mapper.LegacyGeoShapeFieldMapper;
import org.easysearch.index.mapper.MappedFieldType;
import org.easysearch.index.mapper.Mapper;
import org.easysearch.index.mapper.MapperParsingException;

public abstract class AbstractShapeGeometryFieldMapper<Parsed, Processed>
extends AbstractGeometryFieldMapper<Parsed, Processed> {
    protected static final String DEPRECATED_PARAMETERS_KEY = "deprecated_parameters";
    protected Explicit<Boolean> coerce;
    protected Explicit<ShapeBuilder.Orientation> orientation;

    protected AbstractShapeGeometryFieldMapper(String simpleName, FieldType fieldType, MappedFieldType mappedFieldType, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> coerce, Explicit<Boolean> ignoreZValue, Explicit<ShapeBuilder.Orientation> orientation, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, mappedFieldType, ignoreMalformed, ignoreZValue, multiFields, copyTo);
        this.coerce = coerce;
        this.orientation = orientation;
    }

    @Override
    public final boolean parsesArrayValue() {
        return false;
    }

    @Override
    protected final void mergeOptions(FieldMapper other, List<String> conflicts) {
        super.mergeOptions(other, conflicts);
        AbstractShapeGeometryFieldMapper gsfm = (AbstractShapeGeometryFieldMapper)other;
        if (gsfm.coerce.explicit()) {
            this.coerce = gsfm.coerce;
        }
        if (gsfm.orientation.explicit()) {
            this.orientation = gsfm.orientation;
        }
        this.mergeGeoOptions(gsfm, conflicts);
    }

    protected abstract void mergeGeoOptions(AbstractShapeGeometryFieldMapper<?, ?> var1, List<String> var2);

    @Override
    public void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        AbstractShapeGeometryFieldType ft = (AbstractShapeGeometryFieldType)this.fieldType();
        if (includeDefaults || this.coerce.explicit()) {
            builder.field(Names.COERCE.getPreferredName(), this.coerce.value());
        }
        if (includeDefaults || this.orientation.explicit()) {
            builder.field(Names.ORIENTATION.getPreferredName(), (Object)this.orientation.value());
        }
    }

    public Explicit<Boolean> coerce() {
        return this.coerce;
    }

    public ShapeBuilder.Orientation orientation() {
        return ((AbstractShapeGeometryFieldType)this.mappedFieldType).orientation();
    }

    public static abstract class AbstractShapeGeometryFieldType<Parsed, Processed>
    extends AbstractGeometryFieldMapper.AbstractGeometryFieldType<Parsed, Processed> {
        protected ShapeBuilder.Orientation orientation = Defaults.ORIENTATION.value();

        protected AbstractShapeGeometryFieldType(String name, boolean isSearchable, boolean isStored, boolean hasDocValues, boolean parsesArrayValue, Map<String, String> meta) {
            super(name, isSearchable, isStored, hasDocValues, parsesArrayValue, meta);
        }

        public ShapeBuilder.Orientation orientation() {
            return this.orientation;
        }

        public void setOrientation(ShapeBuilder.Orientation orientation) {
            this.orientation = orientation;
        }
    }

    public static class Names
    extends AbstractGeometryFieldMapper.Names {
        public static final ParseField ORIENTATION = new ParseField("orientation", new String[0]);
        public static final ParseField COERCE = new ParseField("coerce", new String[0]);
    }

    public static abstract class TypeParser
    extends AbstractGeometryFieldMapper.TypeParser<Builder> {
        @Override
        protected abstract Builder newBuilder(String var1, Map<String, Object> var2);

        protected boolean parseXContentParameters(String name, Map.Entry<String, Object> entry, Map<String, Object> params) throws MapperParsingException {
            return LegacyGeoShapeFieldMapper.DeprecatedParameters.parse(name, entry.getKey(), entry.getValue(), (LegacyGeoShapeFieldMapper.DeprecatedParameters)params.get(AbstractShapeGeometryFieldMapper.DEPRECATED_PARAMETERS_KEY));
        }

        @Override
        public Builder parse(String name, Map<String, Object> node, Map<String, Object> params, Mapper.TypeParser.ParserContext parserContext) {
            boolean parsedDeprecatedParameters = false;
            params.put(AbstractShapeGeometryFieldMapper.DEPRECATED_PARAMETERS_KEY, new LegacyGeoShapeFieldMapper.DeprecatedParameters());
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = entry.getKey();
                Object fieldNode = entry.getValue();
                if (this.parseXContentParameters(name, entry, params)) {
                    parsedDeprecatedParameters = true;
                    iterator.remove();
                    continue;
                }
                if (Names.ORIENTATION.match(fieldName, LoggingDeprecationHandler.INSTANCE)) {
                    params.put(Names.ORIENTATION.getPreferredName(), (Object)ShapeBuilder.Orientation.fromString(fieldNode.toString()));
                    iterator.remove();
                    continue;
                }
                if (!Names.COERCE.match(fieldName, LoggingDeprecationHandler.INSTANCE)) continue;
                params.put(Names.COERCE.getPreferredName(), XContentMapValues.nodeBooleanValue(fieldNode, name + "." + Names.COERCE.getPreferredName()));
                iterator.remove();
            }
            if (!parsedDeprecatedParameters) {
                params.remove(AbstractShapeGeometryFieldMapper.DEPRECATED_PARAMETERS_KEY);
            }
            Builder builder = (Builder)super.parse(name, node, params, parserContext);
            if (params.containsKey(Names.COERCE.getPreferredName())) {
                builder.coerce((Boolean)params.get(Names.COERCE.getPreferredName()));
            }
            if (params.containsKey(Names.ORIENTATION.getPreferredName())) {
                builder.orientation((ShapeBuilder.Orientation)((Object)params.get(Names.ORIENTATION.getPreferredName())));
            }
            return builder;
        }
    }

    public static abstract class Builder<T extends Builder<T, FT>, FT extends AbstractShapeGeometryFieldType>
    extends AbstractGeometryFieldMapper.Builder<T, FT> {
        protected Boolean coerce;
        protected ShapeBuilder.Orientation orientation;

        public Builder(String name, FieldType fieldType) {
            super(name, fieldType);
        }

        public Builder(String name, FieldType fieldType, boolean coerce, boolean ignoreMalformed, ShapeBuilder.Orientation orientation, boolean ignoreZ) {
            super(name, fieldType, ignoreMalformed, ignoreZ);
            this.coerce = coerce;
            this.orientation = orientation;
        }

        public Builder coerce(boolean coerce) {
            this.coerce = coerce;
            return this;
        }

        protected Explicit<Boolean> coerce(Mapper.BuilderContext context) {
            if (this.coerce != null) {
                return new Explicit<Boolean>(this.coerce, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit<Boolean>(FieldMapper.COERCE_SETTING.get(context.indexSettings()), false);
            }
            return Defaults.COERCE;
        }

        protected Explicit<Boolean> coerce() {
            if (this.coerce != null) {
                return new Explicit<Boolean>(this.coerce, true);
            }
            return Defaults.COERCE;
        }

        public Builder orientation(ShapeBuilder.Orientation orientation) {
            this.orientation = orientation;
            return this;
        }

        protected Explicit<ShapeBuilder.Orientation> orientation() {
            if (this.orientation != null) {
                return new Explicit<ShapeBuilder.Orientation>(this.orientation, true);
            }
            return Defaults.ORIENTATION;
        }
    }

    public static class Defaults
    extends AbstractGeometryFieldMapper.Defaults {
        public static final Explicit<ShapeBuilder.Orientation> ORIENTATION = new Explicit<ShapeBuilder.Orientation>(ShapeBuilder.Orientation.RIGHT, false);
        public static final Explicit<Boolean> COERCE = new Explicit<Boolean>(false, false);
    }
}

