/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.index.engine;

import java.io.IOException;
import java.util.Base64;
import java.util.Map;
import org.apache.lucene.index.SegmentInfos;
import org.easysearch.common.collect.MapBuilder;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.common.io.stream.Writeable;
import org.easysearch.common.lucene.Lucene;
import org.easysearch.common.xcontent.ToXContent;
import org.easysearch.common.xcontent.ToXContentFragment;
import org.easysearch.common.xcontent.XContentBuilder;
import org.easysearch.index.engine.Engine;

public final class CommitStats
implements Writeable,
ToXContentFragment {
    private final Map<String, String> userData;
    private final long generation;
    private final String id;
    private final int numDocs;

    public CommitStats(SegmentInfos segmentInfos) {
        this.userData = MapBuilder.newMapBuilder().putAll(segmentInfos.getUserData()).immutableMap();
        this.generation = segmentInfos.getLastGeneration();
        this.id = Base64.getEncoder().encodeToString(segmentInfos.getId());
        this.numDocs = Lucene.getNumDocs(segmentInfos);
    }

    CommitStats(StreamInput in) throws IOException {
        MapBuilder<String, String> builder = MapBuilder.newMapBuilder();
        for (int i = in.readVInt(); i > 0; --i) {
            builder.put(in.readString(), in.readString());
        }
        this.userData = builder.immutableMap();
        this.generation = in.readLong();
        this.id = in.readOptionalString();
        this.numDocs = in.readInt();
    }

    public static CommitStats readOptionalCommitStatsFrom(StreamInput in) throws IOException {
        return in.readOptionalWriteable(CommitStats::new);
    }

    public Map<String, String> getUserData() {
        return this.userData;
    }

    public long getGeneration() {
        return this.generation;
    }

    public String getId() {
        return this.id;
    }

    public Engine.CommitId getRawCommitId() {
        return new Engine.CommitId(Base64.getDecoder().decode(this.id));
    }

    public String syncId() {
        return this.userData.get("sync_id");
    }

    public int getNumDocs() {
        return this.numDocs;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.userData.size());
        for (Map.Entry<String, String> entry : this.userData.entrySet()) {
            out.writeString(entry.getKey());
            out.writeString(entry.getValue());
        }
        out.writeLong(this.generation);
        out.writeOptionalString(this.id);
        out.writeInt(this.numDocs);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("commit");
        builder.field("id", this.id);
        builder.field("generation", this.generation);
        builder.field("user_data", this.userData);
        builder.field("num_docs", this.numDocs);
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final String GENERATION = "generation";
        static final String USER_DATA = "user_data";
        static final String ID = "id";
        static final String COMMIT = "commit";
        static final String NUM_DOCS = "num_docs";

        Fields() {
        }
    }
}

