/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.index.cache.bitset;

import org.easysearch.common.metrics.CounterMetric;
import org.easysearch.index.IndexSettings;
import org.easysearch.index.shard.AbstractIndexShardComponent;
import org.easysearch.index.shard.ShardId;

public class ShardBitsetFilterCache
extends AbstractIndexShardComponent {
    private final CounterMetric totalMetric = new CounterMetric();

    public ShardBitsetFilterCache(ShardId shardId, IndexSettings indexSettings) {
        super(shardId, indexSettings);
    }

    public void onCached(long sizeInBytes) {
        this.totalMetric.inc(sizeInBytes);
    }

    public void onRemoval(long sizeInBytes) {
        this.totalMetric.dec(sizeInBytes);
    }

    public long getMemorySizeInBytes() {
        return this.totalMetric.count();
    }
}

