/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.index.analysis;

import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.easysearch.common.settings.Settings;
import org.easysearch.env.Environment;
import org.easysearch.index.IndexSettings;
import org.easysearch.index.analysis.AbstractTokenizerFactory;

public class StandardTokenizerFactory
extends AbstractTokenizerFactory {
    private final int maxTokenLength;

    public StandardTokenizerFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, settings, name);
        this.maxTokenLength = settings.getAsInt("max_token_length", 255);
    }

    @Override
    public Tokenizer create() {
        StandardTokenizer tokenizer = new StandardTokenizer();
        tokenizer.setMaxTokenLength(this.maxTokenLength);
        return tokenizer;
    }
}

