/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.gateway;

import java.io.IOException;
import java.util.List;
import org.easysearch.action.ActionFuture;
import org.easysearch.action.ActionType;
import org.easysearch.action.FailedNodeException;
import org.easysearch.action.support.ActionFilters;
import org.easysearch.action.support.PlainActionFuture;
import org.easysearch.action.support.nodes.BaseNodeRequest;
import org.easysearch.action.support.nodes.BaseNodeResponse;
import org.easysearch.action.support.nodes.BaseNodesRequest;
import org.easysearch.action.support.nodes.BaseNodesResponse;
import org.easysearch.action.support.nodes.TransportNodesAction;
import org.easysearch.cluster.ClusterName;
import org.easysearch.cluster.metadata.Metadata;
import org.easysearch.cluster.node.DiscoveryNode;
import org.easysearch.cluster.service.ClusterService;
import org.easysearch.common.Nullable;
import org.easysearch.common.inject.Inject;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.common.unit.TimeValue;
import org.easysearch.gateway.GatewayMetaState;
import org.easysearch.threadpool.ThreadPool;
import org.easysearch.transport.TransportService;

public class TransportNodesListGatewayMetaState
extends TransportNodesAction<Request, NodesGatewayMetaState, NodeRequest, NodeGatewayMetaState> {
    public static final String ACTION_NAME = "internal:gateway/local/meta_state";
    public static final ActionType<NodesGatewayMetaState> TYPE = new ActionType<NodesGatewayMetaState>("internal:gateway/local/meta_state", NodesGatewayMetaState::new);
    private final GatewayMetaState metaState;

    @Inject
    public TransportNodesListGatewayMetaState(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, GatewayMetaState metaState) {
        super(ACTION_NAME, threadPool, clusterService, transportService, actionFilters, Request::new, NodeRequest::new, "generic", NodeGatewayMetaState.class);
        this.metaState = metaState;
    }

    public ActionFuture<NodesGatewayMetaState> list(String[] nodesIds, @Nullable TimeValue timeout) {
        PlainActionFuture<NodesGatewayMetaState> future = PlainActionFuture.newFuture();
        this.execute((Request)new Request(nodesIds).timeout(timeout), future);
        return future;
    }

    @Override
    protected NodeRequest newNodeRequest(Request request) {
        return new NodeRequest();
    }

    @Override
    protected NodeGatewayMetaState newNodeResponse(StreamInput in) throws IOException {
        return new NodeGatewayMetaState(in);
    }

    @Override
    protected NodesGatewayMetaState newResponse(Request request, List<NodeGatewayMetaState> responses, List<FailedNodeException> failures) {
        return new NodesGatewayMetaState(this.clusterService.getClusterName(), responses, failures);
    }

    @Override
    protected NodeGatewayMetaState nodeOperation(NodeRequest request) {
        return new NodeGatewayMetaState(this.clusterService.localNode(), this.metaState.getMetadata());
    }

    public static class NodeGatewayMetaState
    extends BaseNodeResponse {
        private Metadata metadata;

        public NodeGatewayMetaState(StreamInput in) throws IOException {
            super(in);
            if (in.readBoolean()) {
                this.metadata = Metadata.readFrom(in);
            }
        }

        public NodeGatewayMetaState(DiscoveryNode node, Metadata metadata) {
            super(node);
            this.metadata = metadata;
        }

        public Metadata metadata() {
            return this.metadata;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            if (this.metadata == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                this.metadata.writeTo(out);
            }
        }
    }

    public static class Request
    extends BaseNodesRequest<Request> {
        public Request(StreamInput in) throws IOException {
            super(in);
        }

        public Request(String ... nodesIds) {
            super(nodesIds);
        }
    }

    public static class NodeRequest
    extends BaseNodeRequest {
        NodeRequest() {
        }

        NodeRequest(StreamInput in) throws IOException {
            super(in);
        }
    }

    public static class NodesGatewayMetaState
    extends BaseNodesResponse<NodeGatewayMetaState> {
        public NodesGatewayMetaState(StreamInput in) throws IOException {
            super(in);
        }

        public NodesGatewayMetaState(ClusterName clusterName, List<NodeGatewayMetaState> nodes, List<FailedNodeException> failures) {
            super(clusterName, nodes, failures);
        }

        @Override
        protected List<NodeGatewayMetaState> readNodesFrom(StreamInput in) throws IOException {
            return in.readList(NodeGatewayMetaState::new);
        }

        @Override
        protected void writeNodesTo(StreamOutput out, List<NodeGatewayMetaState> nodes) throws IOException {
            out.writeList(nodes);
        }
    }
}

