/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.common.util;

import java.util.Arrays;
import java.util.Locale;
import org.apache.lucene.util.RamUsageEstimator;
import org.easysearch.common.recycler.AbstractRecyclerC;
import org.easysearch.common.recycler.Recycler;
import org.easysearch.common.recycler.Recyclers;
import org.easysearch.common.settings.Setting;
import org.easysearch.common.settings.Settings;
import org.easysearch.common.unit.ByteSizeValue;
import org.easysearch.common.util.concurrent.EsExecutors;

public class PageCacheRecycler {
    public static final Setting<Type> TYPE_SETTING = new Setting<Type>("cache.recycler.page.type", Type.CONCURRENT.name(), Type::parse, Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> LIMIT_HEAP_SETTING = Setting.memorySizeSetting("cache.recycler.page.limit.heap", "10%", Setting.Property.NodeScope);
    public static final Setting<Double> WEIGHT_BYTES_SETTING = Setting.doubleSetting("cache.recycler.page.weight.bytes", 1.0, 0.0, Setting.Property.NodeScope);
    public static final Setting<Double> WEIGHT_LONG_SETTING = Setting.doubleSetting("cache.recycler.page.weight.longs", 1.0, 0.0, Setting.Property.NodeScope);
    public static final Setting<Double> WEIGHT_INT_SETTING = Setting.doubleSetting("cache.recycler.page.weight.ints", 1.0, 0.0, Setting.Property.NodeScope);
    public static final Setting<Double> WEIGHT_OBJECTS_SETTING = Setting.doubleSetting("cache.recycler.page.weight.objects", 0.1, 0.0, Setting.Property.NodeScope);
    public static final int PAGE_SIZE_IN_BYTES = 16384;
    public static final int OBJECT_PAGE_SIZE = 16384 / RamUsageEstimator.NUM_BYTES_OBJECT_REF;
    public static final int LONG_PAGE_SIZE = 2048;
    public static final int INT_PAGE_SIZE = 4096;
    public static final int BYTE_PAGE_SIZE = 16384;
    private final Recycler<byte[]> bytePage;
    private final Recycler<int[]> intPage;
    private final Recycler<long[]> longPage;
    private final Recycler<Object[]> objectPage;
    public static final PageCacheRecycler NON_RECYCLING_INSTANCE = new PageCacheRecycler(Settings.builder().put(LIMIT_HEAP_SETTING.getKey(), "0%").build());

    public PageCacheRecycler(Settings settings) {
        Type type = TYPE_SETTING.get(settings);
        long limit = LIMIT_HEAP_SETTING.get(settings).getBytes();
        int allocatedProcessors = EsExecutors.allocatedProcessors(settings);
        double bytesWeight = WEIGHT_BYTES_SETTING.get(settings);
        double intsWeight = WEIGHT_INT_SETTING.get(settings);
        double longsWeight = WEIGHT_LONG_SETTING.get(settings);
        double objectsWeight = WEIGHT_OBJECTS_SETTING.get(settings);
        double totalWeight = bytesWeight + intsWeight + longsWeight + objectsWeight;
        int maxPageCount = (int)Math.min(Integer.MAX_VALUE, limit / 16384L);
        int maxBytePageCount = (int)(bytesWeight * (double)maxPageCount / totalWeight);
        this.bytePage = PageCacheRecycler.build(type, maxBytePageCount, allocatedProcessors, new AbstractRecyclerC<byte[]>(){

            @Override
            public byte[] newInstance() {
                return new byte[16384];
            }

            @Override
            public void recycle(byte[] value) {
            }
        });
        int maxIntPageCount = (int)(intsWeight * (double)maxPageCount / totalWeight);
        this.intPage = PageCacheRecycler.build(type, maxIntPageCount, allocatedProcessors, new AbstractRecyclerC<int[]>(){

            @Override
            public int[] newInstance() {
                return new int[4096];
            }

            @Override
            public void recycle(int[] value) {
            }
        });
        int maxLongPageCount = (int)(longsWeight * (double)maxPageCount / totalWeight);
        this.longPage = PageCacheRecycler.build(type, maxLongPageCount, allocatedProcessors, new AbstractRecyclerC<long[]>(){

            @Override
            public long[] newInstance() {
                return new long[2048];
            }

            @Override
            public void recycle(long[] value) {
            }
        });
        int maxObjectPageCount = (int)(objectsWeight * (double)maxPageCount / totalWeight);
        this.objectPage = PageCacheRecycler.build(type, maxObjectPageCount, allocatedProcessors, new AbstractRecyclerC<Object[]>(){

            @Override
            public Object[] newInstance() {
                return new Object[OBJECT_PAGE_SIZE];
            }

            @Override
            public void recycle(Object[] value) {
                Arrays.fill(value, null);
            }
        });
        assert ((long)(16384 * (maxBytePageCount + maxIntPageCount + maxLongPageCount + maxObjectPageCount)) <= limit);
    }

    public Recycler.V<byte[]> bytePage(boolean clear) {
        Recycler.V<byte[]> v = this.bytePage.obtain();
        if (v.isRecycled() && clear) {
            Arrays.fill(v.v(), (byte)0);
        }
        return v;
    }

    public Recycler.V<int[]> intPage(boolean clear) {
        Recycler.V<int[]> v = this.intPage.obtain();
        if (v.isRecycled() && clear) {
            Arrays.fill(v.v(), 0);
        }
        return v;
    }

    public Recycler.V<long[]> longPage(boolean clear) {
        Recycler.V<long[]> v = this.longPage.obtain();
        if (v.isRecycled() && clear) {
            Arrays.fill(v.v(), 0L);
        }
        return v;
    }

    public Recycler.V<Object[]> objectPage() {
        return this.objectPage.obtain();
    }

    private static <T> Recycler<T> build(Type type, int limit, int availableProcessors, Recycler.C<T> c) {
        Recycler<T> recycler = limit == 0 ? Recyclers.none(c) : type.build(c, limit, availableProcessors);
        return recycler;
    }

    public static enum Type {
        QUEUE{

            @Override
            <T> Recycler<T> build(Recycler.C<T> c, int limit, int availableProcessors) {
                return Recyclers.concurrentDeque(c, limit);
            }
        }
        ,
        CONCURRENT{

            @Override
            <T> Recycler<T> build(Recycler.C<T> c, int limit, int availableProcessors) {
                return Recyclers.concurrent(Recyclers.dequeFactory(c, limit / availableProcessors), availableProcessors);
            }
        }
        ,
        NONE{

            @Override
            <T> Recycler<T> build(Recycler.C<T> c, int limit, int availableProcessors) {
                return Recyclers.none(c);
            }
        };


        public static Type parse(String type) {
            try {
                return Type.valueOf(type.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("no type support [" + type + "]");
            }
        }

        abstract <T> Recycler<T> build(Recycler.C<T> var1, int var2, int var3);
    }
}

