/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.common.lucene.search;

import java.util.ArrayList;
import java.util.PrimitiveIterator;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.AutomatonQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.MinimizationOperations;
import org.apache.lucene.util.automaton.Operations;

public class AutomatonQueries {
    public static final char WILDCARD_STRING = '*';
    public static final char WILDCARD_CHAR = '?';
    public static final char WILDCARD_ESCAPE = '\\';

    public static Automaton caseInsensitivePrefix(String s2) {
        ArrayList<Automaton> list = new ArrayList<Automaton>();
        PrimitiveIterator.OfInt iter = s2.codePoints().iterator();
        while (iter.hasNext()) {
            list.add(AutomatonQueries.toCaseInsensitiveChar((Integer)iter.next(), Integer.MAX_VALUE));
        }
        list.add(Automata.makeAnyString());
        Automaton a = Operations.concatenate(list);
        a = MinimizationOperations.minimize((Automaton)a, (int)Integer.MAX_VALUE);
        return a;
    }

    public static AutomatonQuery caseInsensitivePrefixQuery(Term prefix) {
        return new AutomatonQuery(prefix, AutomatonQueries.caseInsensitivePrefix(prefix.text()));
    }

    public static AutomatonQuery caseInsensitiveTermQuery(Term term) {
        BytesRef prefix = term.bytes();
        return new AutomatonQuery(term, AutomatonQueries.toCaseInsensitiveString(prefix, Integer.MAX_VALUE));
    }

    public static AutomatonQuery caseInsensitiveWildcardQuery(Term wildcardquery) {
        return new AutomatonQuery(wildcardquery, AutomatonQueries.toCaseInsensitiveWildcardAutomaton(wildcardquery, Integer.MAX_VALUE));
    }

    public static Automaton toCaseInsensitiveWildcardAutomaton(Term wildcardquery, int maxDeterminizedStates) {
        int length;
        ArrayList<Automaton> automata = new ArrayList<Automaton>();
        String wildcardText = wildcardquery.text();
        block5: for (int i = 0; i < wildcardText.length(); i += length) {
            int c = wildcardText.codePointAt(i);
            length = Character.charCount(c);
            switch (c) {
                case 42: {
                    automata.add(Automata.makeAnyString());
                    continue block5;
                }
                case 63: {
                    automata.add(Automata.makeAnyChar());
                    continue block5;
                }
                case 92: {
                    if (i + length < wildcardText.length()) {
                        int nextChar = wildcardText.codePointAt(i + length);
                        length += Character.charCount(nextChar);
                        automata.add(Automata.makeChar((int)nextChar));
                        continue block5;
                    }
                }
                default: {
                    automata.add(AutomatonQueries.toCaseInsensitiveChar(c, maxDeterminizedStates));
                }
            }
        }
        return Operations.concatenate(automata);
    }

    protected static Automaton toCaseInsensitiveString(BytesRef br, int maxDeterminizedStates) {
        return AutomatonQueries.toCaseInsensitiveString(br.utf8ToString(), maxDeterminizedStates);
    }

    public static Automaton toCaseInsensitiveString(String s2, int maxDeterminizedStates) {
        ArrayList<Automaton> list = new ArrayList<Automaton>();
        PrimitiveIterator.OfInt iter = s2.codePoints().iterator();
        while (iter.hasNext()) {
            list.add(AutomatonQueries.toCaseInsensitiveChar((Integer)iter.next(), maxDeterminizedStates));
        }
        Automaton a = Operations.concatenate(list);
        a = MinimizationOperations.minimize((Automaton)a, (int)maxDeterminizedStates);
        return a;
    }

    public static Automaton toCaseInsensitiveChar(int codepoint, int maxDeterminizedStates) {
        Automaton result;
        int altCase;
        Automaton case1 = Automata.makeChar((int)codepoint);
        if (codepoint > 128) {
            return case1;
        }
        int n = altCase = Character.isLowerCase(codepoint) ? Character.toUpperCase(codepoint) : Character.toLowerCase(codepoint);
        if (altCase != codepoint) {
            result = Operations.union((Automaton)case1, (Automaton)Automata.makeChar((int)altCase));
            result = MinimizationOperations.minimize((Automaton)result, (int)maxDeterminizedStates);
        } else {
            result = case1;
        }
        return result;
    }
}

