/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.common.logging;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.easysearch.Build;
import org.easysearch.Version;
import org.easysearch.common.logging.LoggerMessageFormat;
import org.easysearch.common.util.concurrent.ThreadContext;

public class HeaderWarning {
    public static final Pattern WARNING_HEADER_PATTERN;
    public static final Pattern WARNING_XCONTENT_LOCATION_PATTERN;
    private static final String WARNING_PREFIX;
    private static BitSet doesNotNeedEncoding;
    private static final Charset UTF_8;
    static final CopyOnWriteArraySet<ThreadContext> THREAD_CONTEXT;

    public static void setThreadContext(ThreadContext threadContext) {
        Objects.requireNonNull(threadContext, "Cannot register a null ThreadContext");
        if (!THREAD_CONTEXT.add(threadContext)) {
            throw new IllegalStateException("Double-setting ThreadContext not allowed!");
        }
    }

    public static void removeThreadContext(ThreadContext threadContext) {
        assert (threadContext != null);
        if (!THREAD_CONTEXT.remove(threadContext)) {
            throw new IllegalStateException("Removing unknown ThreadContext not allowed!");
        }
    }

    public static String extractWarningValueFromWarningHeader(String s2, boolean stripXContentPosition) {
        Matcher matcher;
        int firstQuote = s2.indexOf(34);
        int lastQuote = s2.length() - 1;
        String warningValue = s2.substring(firstQuote + 1, lastQuote);
        assert (HeaderWarning.assertWarningValue(s2, warningValue));
        if (stripXContentPosition && (matcher = WARNING_XCONTENT_LOCATION_PATTERN.matcher(warningValue)).find()) {
            warningValue = warningValue.substring(matcher.end());
        }
        return warningValue;
    }

    private static boolean assertWarningValue(String s2, String warningValue) {
        Matcher matcher = WARNING_HEADER_PATTERN.matcher(s2);
        boolean matches = matcher.matches();
        assert (matches);
        return matcher.group(1).equals(warningValue);
    }

    public static String formatWarning(String s2) {
        int length = WARNING_PREFIX.length() + s2.length() + 3;
        StringBuilder sb = new StringBuilder(length);
        sb.append(WARNING_PREFIX).append(" \"").append(HeaderWarning.escapeAndEncode(s2)).append("\"");
        return sb.toString();
    }

    public static String escapeAndEncode(String s2) {
        return HeaderWarning.encode(HeaderWarning.escapeBackslashesAndQuotes(s2));
    }

    static String escapeBackslashesAndQuotes(String s2) {
        boolean escapingNeeded = false;
        for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            if (c != '\\' && c != '\"') continue;
            escapingNeeded = true;
            break;
        }
        if (escapingNeeded) {
            StringBuilder sb = new StringBuilder();
            for (char c : s2.toCharArray()) {
                if (c == '\\' || c == '\"') {
                    sb.append("\\");
                }
                sb.append(c);
            }
            return sb.toString();
        }
        return s2;
    }

    static String encode(String s2) {
        boolean encodingNeeded = false;
        for (int i = 0; i < s2.length(); ++i) {
            char current = s2.charAt(i);
            if (doesNotNeedEncoding.get(current)) continue;
            encodingNeeded = true;
            break;
        }
        if (!encodingNeeded) {
            return s2;
        }
        StringBuilder sb = new StringBuilder(s2.length());
        int i = 0;
        while (i < s2.length()) {
            char current = s2.charAt(i);
            if (doesNotNeedEncoding.get(current)) {
                sb.append(current);
                ++i;
                continue;
            }
            int startIndex = i;
            while (++i < s2.length() && !doesNotNeedEncoding.get(s2.charAt(i))) {
            }
            byte[] bytes = s2.substring(startIndex, i).getBytes(UTF_8);
            for (int j = 0; j < bytes.length; ++j) {
                sb.append('%').append(HeaderWarning.hex(bytes[j] >> 4)).append(HeaderWarning.hex(bytes[j]));
            }
        }
        return sb.toString();
    }

    private static char hex(int b) {
        char ch = Character.forDigit(b & 0xF, 16);
        if (Character.isLetter(ch)) {
            return Character.toUpperCase(ch);
        }
        return ch;
    }

    public static String getXOpaqueId() {
        return THREAD_CONTEXT.stream().filter(t -> t.getHeader("X-Opaque-Id") != null).findFirst().map(t -> t.getHeader("X-Opaque-Id")).orElse("");
    }

    public static void addWarning(String message, Object ... params) {
        HeaderWarning.addWarning(THREAD_CONTEXT, message, params);
    }

    static void addWarning(Set<ThreadContext> threadContexts, String message, Object ... params) {
        Iterator<ThreadContext> iterator = threadContexts.iterator();
        if (iterator.hasNext()) {
            String formattedMessage = LoggerMessageFormat.format(message, params);
            String warningHeaderValue = HeaderWarning.formatWarning(formattedMessage);
            assert (WARNING_HEADER_PATTERN.matcher(warningHeaderValue).matches());
            assert (HeaderWarning.extractWarningValueFromWarningHeader(warningHeaderValue, false).equals(HeaderWarning.escapeAndEncode(formattedMessage)));
            while (iterator.hasNext()) {
                try {
                    ThreadContext next = iterator.next();
                    next.addResponseHeader("Warning", warningHeaderValue);
                }
                catch (IllegalStateException illegalStateException) {}
            }
        }
    }

    static {
        int i;
        WARNING_HEADER_PATTERN = Pattern.compile("299 Easysearch-\\d+\\.\\d+\\.\\d+(?:-(?:alpha|beta|rc)\\d+)?(?:-SNAPSHOT)?-(?:[a-f0-9]{7}(?:[a-f0-9]{33})?|unknown) \"((?:\t| |!|[\\x23-\\x5B]|[\\x5D-\\x7E]|[\\x80-\\xFF]|\\\\|\\\\\")*)\"( \"(?:Mon|Tue|Wed|Thu|Fri|Sat|Sun), \\d{2} (?:Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) \\d{4} \\d{2}:\\d{2}:\\d{2} GMT\")?");
        WARNING_XCONTENT_LOCATION_PATTERN = Pattern.compile("^\\[.*?]\\[-?\\d+:-?\\d+] ");
        WARNING_PREFIX = String.format(Locale.ROOT, "299 Easysearch-%s%s-%s", Version.CURRENT.toString(), Build.CURRENT.isSnapshot() ? "-SNAPSHOT" : "", Build.CURRENT.hash());
        doesNotNeedEncoding = new BitSet(256);
        doesNotNeedEncoding.set(9);
        doesNotNeedEncoding.set(32);
        doesNotNeedEncoding.set(33);
        doesNotNeedEncoding.set(92);
        doesNotNeedEncoding.set(34);
        for (i = 35; i <= 36; ++i) {
            doesNotNeedEncoding.set(i);
        }
        for (i = 38; i <= 91; ++i) {
            doesNotNeedEncoding.set(i);
        }
        for (i = 93; i <= 126; ++i) {
            doesNotNeedEncoding.set(i);
        }
        for (i = 128; i <= 255; ++i) {
            doesNotNeedEncoding.set(i);
        }
        assert (!doesNotNeedEncoding.get(37)) : doesNotNeedEncoding;
        UTF_8 = StandardCharsets.UTF_8;
        THREAD_CONTEXT = new CopyOnWriteArraySet();
    }
}

