/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.common.logging;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.easysearch.common.SuppressLoggerChecks;

@SuppressLoggerChecks(reason="Safe as this is abstract class")
public abstract class ESLogMessage
extends ParameterizedMessage {
    private final Map<String, Object> fields;

    public ESLogMessage(Map<String, Object> fields, String messagePattern, Object ... args) {
        super(messagePattern, args);
        this.fields = fields;
    }

    public String getValueFor(String key) {
        Object value = this.fields.get(key);
        return value != null ? value.toString() : null;
    }

    public static String inQuotes(String s2) {
        if (s2 == null) {
            return ESLogMessage.inQuotes("");
        }
        return "\"" + s2 + "\"";
    }

    public static String inQuotes(Object s2) {
        if (s2 == null) {
            return ESLogMessage.inQuotes("");
        }
        return ESLogMessage.inQuotes(s2.toString());
    }

    public static String asJsonArray(Stream<String> stream) {
        return "[" + stream.map(ESLogMessage::inQuotes).collect(Collectors.joining(", ")) + "]";
    }

    public Object[] getArguments() {
        return super.getParameters();
    }

    public String getMessagePattern() {
        return super.getFormat();
    }
}

