/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.common.io.stream;

import java.io.IOException;
import org.easysearch.EasysearchException;
import org.easysearch.ExceptionsHelper;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.rest.RestStatus;

public final class NotSerializableExceptionWrapper
extends EasysearchException {
    private final String name;
    private final RestStatus status;

    public NotSerializableExceptionWrapper(Throwable other) {
        super(EasysearchException.getExceptionName(other) + ": " + other.getMessage(), other.getCause(), new Object[0]);
        this.name = EasysearchException.getExceptionName(other);
        this.status = ExceptionsHelper.status(other);
        this.setStackTrace(other.getStackTrace());
        for (Throwable otherSuppressed : other.getSuppressed()) {
            this.addSuppressed(otherSuppressed);
        }
        if (other instanceof EasysearchException) {
            EasysearchException ex = (EasysearchException)other;
            for (String key : ex.getHeaderKeys()) {
                this.addHeader(key, ex.getHeader(key));
            }
            for (String key : ex.getMetadataKeys()) {
                this.addMetadata(key, ex.getMetadata(key));
            }
        }
    }

    public NotSerializableExceptionWrapper(StreamInput in) throws IOException {
        super(in);
        this.name = in.readString();
        this.status = RestStatus.readFrom(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.name);
        RestStatus.writeTo(out, this.status);
    }

    @Override
    protected String getExceptionName() {
        return this.name;
    }

    @Override
    public RestStatus status() {
        return this.status;
    }
}

