/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.common.inject.internal;

import org.easysearch.common.inject.Binder;
import org.easysearch.common.inject.Injector;
import org.easysearch.common.inject.Key;
import org.easysearch.common.inject.Provider;
import org.easysearch.common.inject.internal.BindingImpl;
import org.easysearch.common.inject.internal.InternalFactory;
import org.easysearch.common.inject.internal.Scoping;
import org.easysearch.common.inject.internal.ToStringBuilder;
import org.easysearch.common.inject.spi.BindingTargetVisitor;
import org.easysearch.common.inject.spi.ProviderKeyBinding;

public final class LinkedProviderBindingImpl<T>
extends BindingImpl<T>
implements ProviderKeyBinding<T> {
    final Key<? extends Provider<? extends T>> providerKey;

    public LinkedProviderBindingImpl(Injector injector, Key<T> key, Object source, InternalFactory<? extends T> internalFactory, Scoping scoping, Key<? extends Provider<? extends T>> providerKey) {
        super(injector, key, source, internalFactory, scoping);
        this.providerKey = providerKey;
    }

    LinkedProviderBindingImpl(Object source, Key<T> key, Scoping scoping, Key<? extends Provider<? extends T>> providerKey) {
        super(source, key, scoping);
        this.providerKey = providerKey;
    }

    @Override
    public <V> V acceptTargetVisitor(BindingTargetVisitor<? super T, V> visitor) {
        return visitor.visit(this);
    }

    @Override
    public Key<? extends Provider<? extends T>> getProviderKey() {
        return this.providerKey;
    }

    @Override
    public BindingImpl<T> withScoping(Scoping scoping) {
        return new LinkedProviderBindingImpl(this.getSource(), this.getKey(), scoping, this.providerKey);
    }

    @Override
    public BindingImpl<T> withKey(Key<T> key) {
        return new LinkedProviderBindingImpl<T>(this.getSource(), key, this.getScoping(), this.providerKey);
    }

    @Override
    public void applyTo(Binder binder) {
        this.getScoping().applyTo(binder.withSource(this.getSource()).bind(this.getKey()).toProvider(this.getProviderKey()));
    }

    @Override
    public String toString() {
        return new ToStringBuilder(ProviderKeyBinding.class).add("key", this.getKey()).add("source", this.getSource()).add("scope", this.getScoping()).add("provider", this.providerKey).toString();
    }
}

