/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.common.inject;

import java.util.Iterator;
import java.util.List;
import org.easysearch.common.inject.Binding;
import org.easysearch.common.inject.InjectorImpl;
import org.easysearch.common.inject.InjectorShell;
import org.easysearch.common.inject.internal.Errors;
import org.easysearch.common.inject.spi.Element;
import org.easysearch.common.inject.spi.ElementVisitor;
import org.easysearch.common.inject.spi.InjectionRequest;
import org.easysearch.common.inject.spi.MembersInjectorLookup;
import org.easysearch.common.inject.spi.Message;
import org.easysearch.common.inject.spi.PrivateElements;
import org.easysearch.common.inject.spi.ProviderLookup;
import org.easysearch.common.inject.spi.ScopeBinding;
import org.easysearch.common.inject.spi.StaticInjectionRequest;
import org.easysearch.common.inject.spi.TypeConverterBinding;
import org.easysearch.common.inject.spi.TypeListenerBinding;

abstract class AbstractProcessor
implements ElementVisitor<Boolean> {
    protected Errors errors;
    protected InjectorImpl injector;

    protected AbstractProcessor(Errors errors) {
        this.errors = errors;
    }

    public void process(Iterable<InjectorShell> isolatedInjectorBuilders) {
        for (InjectorShell injectorShell : isolatedInjectorBuilders) {
            this.process(injectorShell.getInjector(), injectorShell.getElements());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(InjectorImpl injector, List<Element> elements) {
        Errors errorsAnyElement = this.errors;
        this.injector = injector;
        try {
            Iterator<Element> i = elements.iterator();
            while (i.hasNext()) {
                Element element = i.next();
                this.errors = errorsAnyElement.withSource(element.getSource());
                Boolean allDone = element.acceptVisitor(this);
                if (!allDone.booleanValue()) continue;
                i.remove();
            }
        }
        finally {
            this.errors = errorsAnyElement;
            this.injector = null;
        }
    }

    @Override
    public Boolean visit(Message message) {
        return false;
    }

    @Override
    public Boolean visit(ScopeBinding scopeBinding) {
        return false;
    }

    @Override
    public Boolean visit(InjectionRequest<?> injectionRequest) {
        return false;
    }

    @Override
    public Boolean visit(StaticInjectionRequest staticInjectionRequest) {
        return false;
    }

    @Override
    public Boolean visit(TypeConverterBinding typeConverterBinding) {
        return false;
    }

    @Override
    public <T> Boolean visit(Binding<T> binding) {
        return false;
    }

    @Override
    public <T> Boolean visit(ProviderLookup<T> providerLookup) {
        return false;
    }

    @Override
    public Boolean visit(PrivateElements privateElements) {
        return false;
    }

    @Override
    public <T> Boolean visit(MembersInjectorLookup<T> lookup) {
        return false;
    }

    @Override
    public Boolean visit(TypeListenerBinding binding) {
        return false;
    }
}

