/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.common;

import java.time.Instant;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.easysearch.common.Strings;
import org.easysearch.common.time.DateFormatter;

public class Table {
    private List<Cell> headers = new ArrayList<Cell>();
    private List<List<Cell>> rows = new ArrayList<List<Cell>>();
    private Map<String, List<Cell>> map = new HashMap<String, List<Cell>>();
    private Map<String, Cell> headerMap = new HashMap<String, Cell>();
    private List<Cell> currentCells;
    private boolean inHeaders = false;
    private boolean withTime = false;
    public static final String EPOCH = "epoch";
    public static final String TIMESTAMP = "timestamp";
    private static final DateFormatter FORMATTER = DateFormatter.forPattern("HH:mm:ss").withZone(ZoneOffset.UTC);

    public Table startHeaders() {
        this.inHeaders = true;
        this.currentCells = new ArrayList<Cell>();
        return this;
    }

    public Table startHeadersWithTimestamp() {
        this.startHeaders();
        this.withTime = true;
        this.addCell(EPOCH, "alias:t,time;desc:seconds since 1970-01-01 00:00:00");
        this.addCell(TIMESTAMP, "alias:ts,hms,hhmmss;desc:time in HH:MM:SS");
        return this;
    }

    public Table endHeaders() {
        if (this.currentCells == null || this.currentCells.isEmpty()) {
            throw new IllegalStateException("no headers added...");
        }
        this.inHeaders = false;
        this.headers = this.currentCells;
        this.currentCells = null;
        for (Cell header : this.headers) {
            this.map.put(header.value.toString(), new ArrayList());
            this.headerMap.put(header.value.toString(), header);
        }
        return this;
    }

    public Table startRow() {
        if (this.headers.isEmpty()) {
            throw new IllegalStateException("no headers added...");
        }
        this.currentCells = new ArrayList<Cell>(this.headers.size());
        if (this.withTime) {
            long time = System.currentTimeMillis();
            this.addCell(TimeUnit.SECONDS.convert(time, TimeUnit.MILLISECONDS));
            this.addCell(FORMATTER.format(Instant.ofEpochMilli(time)));
        }
        return this;
    }

    public Table endRow(boolean check) {
        if (this.currentCells == null) {
            throw new IllegalStateException("no row started...");
        }
        if (check && this.currentCells.size() != this.headers.size()) {
            StringBuilder s2 = new StringBuilder();
            s2.append("mismatch on number of cells ");
            s2.append(this.currentCells.size());
            s2.append(" in a row compared to header ");
            s2.append(this.headers.size());
            throw new IllegalStateException(s2.toString());
        }
        this.rows.add(this.currentCells);
        this.currentCells = null;
        return this;
    }

    public Table endRow() {
        this.endRow(true);
        return this;
    }

    public Table addCell(Object value) {
        return this.addCell(value, "");
    }

    public Table addCell(Object value, String attributes) {
        Map<Object, Object> mAttr;
        if (this.currentCells == null) {
            throw new IllegalStateException("no block started...");
        }
        if (!this.inHeaders && this.currentCells.size() == this.headers.size()) {
            throw new IllegalStateException("can't add more cells to a row than the header");
        }
        if (attributes.length() == 0) {
            mAttr = this.inHeaders ? Collections.emptyMap() : this.headers.get((int)this.currentCells.size()).attr;
        } else {
            String[] sAttrs;
            mAttr = new HashMap();
            if (!this.inHeaders) {
                mAttr.putAll(this.headers.get((int)this.currentCells.size()).attr);
            }
            for (String sAttr : sAttrs = attributes.split(";")) {
                if (sAttr.length() == 0) continue;
                int idx = sAttr.indexOf(58);
                mAttr.put(sAttr.substring(0, idx), sAttr.substring(idx + 1));
            }
        }
        Cell cell = new Cell(value, mAttr);
        int cellIndex = this.currentCells.size();
        this.currentCells.add(cell);
        if (!this.inHeaders) {
            String hdr = (String)this.headers.get((int)cellIndex).value;
            this.map.get(hdr).add(cell);
        }
        return this;
    }

    public List<Cell> getHeaders() {
        return this.headers;
    }

    public List<List<Cell>> getRows() {
        return this.rows;
    }

    public Map<String, List<Cell>> getAsMap() {
        return this.map;
    }

    public Map<String, Cell> getHeaderMap() {
        return this.headerMap;
    }

    public Cell findHeaderByName(String header) {
        for (Cell cell : this.headers) {
            if (!cell.value.toString().equals(header)) continue;
            return cell;
        }
        return null;
    }

    public Map<String, String> getAliasMap() {
        HashMap<String, String> headerAliasMap = new HashMap<String, String>();
        for (int i = 0; i < this.headers.size(); ++i) {
            Cell headerCell = this.headers.get(i);
            String headerName = headerCell.value.toString();
            if (headerCell.attr.containsKey("alias")) {
                String[] aliases;
                for (String alias : aliases = Strings.splitStringByCommaToArray(headerCell.attr.get("alias"))) {
                    headerAliasMap.put(alias, headerName);
                }
            }
            headerAliasMap.put(headerName, headerName);
        }
        return headerAliasMap;
    }

    public static class Cell {
        public final Object value;
        public final Map<String, String> attr;

        public Cell(Object value, Cell other) {
            this.value = value;
            this.attr = other.attr;
        }

        public Cell(Object value) {
            this.value = value;
            this.attr = new HashMap<String, String>();
        }

        public Cell(Object value, Map<String, String> attr) {
            this.value = value;
            this.attr = attr;
        }
    }
}

