/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.cluster.routing.allocation;

import java.io.IOException;
import org.easysearch.cluster.routing.allocation.command.AllocationCommand;
import org.easysearch.cluster.routing.allocation.decider.Decision;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.common.xcontent.ToXContent;
import org.easysearch.common.xcontent.ToXContentObject;
import org.easysearch.common.xcontent.XContentBuilder;

public class RerouteExplanation
implements ToXContentObject {
    private AllocationCommand command;
    private Decision decisions;

    public RerouteExplanation(AllocationCommand command, Decision decisions) {
        this.command = command;
        this.decisions = decisions;
    }

    public AllocationCommand command() {
        return this.command;
    }

    public Decision decisions() {
        return this.decisions;
    }

    public static RerouteExplanation readFrom(StreamInput in) throws IOException {
        AllocationCommand command = in.readNamedWriteable(AllocationCommand.class);
        Decision decisions = Decision.readFrom(in);
        return new RerouteExplanation(command, decisions);
    }

    public static void writeTo(RerouteExplanation explanation, StreamOutput out) throws IOException {
        out.writeNamedWriteable(explanation.command);
        explanation.decisions.writeTo(out);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("command", this.command.name());
        builder.field("parameters", this.command);
        builder.startArray("decisions");
        this.decisions.toXContent(builder, params);
        builder.endArray();
        builder.endObject();
        return builder;
    }
}

