/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.cluster.metadata;

import java.io.IOException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import org.easysearch.Version;
import org.easysearch.cluster.Diff;
import org.easysearch.cluster.NamedDiff;
import org.easysearch.cluster.metadata.Metadata;
import org.easysearch.common.ParseField;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.common.io.stream.Writeable;
import org.easysearch.common.settings.Setting;
import org.easysearch.common.settings.Settings;
import org.easysearch.common.time.DateFormatter;
import org.easysearch.common.xcontent.ContextParser;
import org.easysearch.common.xcontent.ObjectParser;
import org.easysearch.common.xcontent.ToXContent;
import org.easysearch.common.xcontent.ToXContentObject;
import org.easysearch.common.xcontent.XContentBuilder;
import org.easysearch.common.xcontent.XContentParser;
import org.easysearch.index.Index;

public final class IndexGraveyard
implements Metadata.Custom {
    public static final Setting<Integer> SETTING_MAX_TOMBSTONES = Setting.intSetting("cluster.indices.tombstones.size", 500, Setting.Property.NodeScope);
    public static final String TYPE = "index-graveyard";
    private static final ParseField TOMBSTONES_FIELD = new ParseField("tombstones", new String[0]);
    private static final ObjectParser<List<Tombstone>, Void> GRAVEYARD_PARSER = new ObjectParser("index_graveyard", ArrayList::new);
    private final List<Tombstone> tombstones;

    private IndexGraveyard(List<Tombstone> list) {
        assert (list != null);
        this.tombstones = Collections.unmodifiableList(list);
    }

    public IndexGraveyard(StreamInput in) throws IOException {
        this.tombstones = Collections.unmodifiableList(in.readList(x$0 -> new Tombstone(x$0)));
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public Version getMinimalSupportedVersion() {
        return Version.CURRENT.minimumCompatibilityVersion();
    }

    @Override
    public EnumSet<Metadata.XContentContext> context() {
        return Metadata.API_AND_GATEWAY;
    }

    public boolean equals(Object obj) {
        return obj instanceof IndexGraveyard && Objects.equals(this.tombstones, ((IndexGraveyard)obj).tombstones);
    }

    public int hashCode() {
        return this.tombstones.hashCode();
    }

    public List<Tombstone> getTombstones() {
        return this.tombstones;
    }

    public boolean containsIndex(Index index) {
        for (Tombstone tombstone : this.tombstones) {
            if (!tombstone.getIndex().equals(index)) continue;
            return true;
        }
        return false;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(TOMBSTONES_FIELD.getPreferredName());
        for (Tombstone tombstone : this.tombstones) {
            tombstone.toXContent(builder, params);
        }
        return builder.endArray();
    }

    public static IndexGraveyard fromXContent(XContentParser parser) throws IOException {
        return new IndexGraveyard(GRAVEYARD_PARSER.parse(parser, null));
    }

    public String toString() {
        return "IndexGraveyard[" + this.tombstones + "]";
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.tombstones);
    }

    @Override
    public Diff<Metadata.Custom> diff(Metadata.Custom previous) {
        return new IndexGraveyardDiff((IndexGraveyard)previous, this);
    }

    public static NamedDiff<Metadata.Custom> readDiffFrom(StreamInput in) throws IOException {
        return new IndexGraveyardDiff(in);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(IndexGraveyard graveyard) {
        return new Builder(graveyard);
    }

    static {
        GRAVEYARD_PARSER.declareObjectArray(List::addAll, Tombstone.getParser(), TOMBSTONES_FIELD);
    }

    public static final class Tombstone
    implements ToXContentObject,
    Writeable {
        private static final String INDEX_KEY = "index";
        private static final String DELETE_DATE_IN_MILLIS_KEY = "delete_date_in_millis";
        private static final String DELETE_DATE_KEY = "delete_date";
        private static final ObjectParser<Builder, Void> TOMBSTONE_PARSER = new ObjectParser("tombstoneEntry", () -> new Builder());
        static final DateFormatter FORMATTER;
        private final Index index;
        private final long deleteDateInMillis;

        static ContextParser<Void, Tombstone> getParser() {
            return (parser, context) -> TOMBSTONE_PARSER.apply(parser, null).build();
        }

        private Tombstone(Index index, long deleteDateInMillis) {
            Objects.requireNonNull(index);
            if (deleteDateInMillis < 0L) {
                throw new IllegalArgumentException("invalid deleteDateInMillis [" + deleteDateInMillis + "]");
            }
            this.index = index;
            this.deleteDateInMillis = deleteDateInMillis;
        }

        private Tombstone(StreamInput in) throws IOException {
            this.index = new Index(in);
            this.deleteDateInMillis = in.readLong();
        }

        public Index getIndex() {
            return this.index;
        }

        public long getDeleteDateInMillis() {
            return this.deleteDateInMillis;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.index.writeTo(out);
            out.writeLong(this.deleteDateInMillis);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Tombstone that = (Tombstone)other;
            return this.index.equals(that.index) && this.deleteDateInMillis == that.deleteDateInMillis;
        }

        public int hashCode() {
            int result = this.index.hashCode();
            result = 31 * result + Long.hashCode(this.deleteDateInMillis);
            return result;
        }

        public String toString() {
            String date = FORMATTER.format(Instant.ofEpochMilli(this.deleteDateInMillis));
            return "[index=" + this.index + ", deleteDate=" + date + "]";
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(INDEX_KEY);
            this.index.toXContent(builder, params);
            builder.timeField(DELETE_DATE_IN_MILLIS_KEY, DELETE_DATE_KEY, this.deleteDateInMillis);
            return builder.endObject();
        }

        static {
            TOMBSTONE_PARSER.declareObject(Builder::index, (parser, context) -> Index.fromXContent(parser), new ParseField(INDEX_KEY, new String[0]));
            TOMBSTONE_PARSER.declareLong(Builder::deleteDateInMillis, new ParseField(DELETE_DATE_IN_MILLIS_KEY, new String[0]));
            TOMBSTONE_PARSER.declareString((b, s2) -> {}, new ParseField(DELETE_DATE_KEY, new String[0]));
            FORMATTER = DateFormatter.forPattern("strict_date_optional_time").withZone(ZoneOffset.UTC);
        }

        private static final class Builder {
            private Index index;
            private long deleteDateInMillis = -1L;

            private Builder() {
            }

            public void index(Index index) {
                this.index = index;
            }

            public void deleteDateInMillis(long deleteDate) {
                this.deleteDateInMillis = deleteDate;
            }

            public Tombstone build() {
                assert (this.index != null);
                assert (this.deleteDateInMillis > -1L);
                return new Tombstone(this.index, this.deleteDateInMillis);
            }
        }
    }

    public static final class IndexGraveyardDiff
    implements NamedDiff<Metadata.Custom> {
        private final List<Tombstone> added;
        private final int removedCount;

        IndexGraveyardDiff(StreamInput in) throws IOException {
            this.added = Collections.unmodifiableList(in.readList(streamInput -> new Tombstone(streamInput)));
            this.removedCount = in.readVInt();
        }

        IndexGraveyardDiff(IndexGraveyard previous, IndexGraveyard current) {
            int removed;
            List<Tombstone> added;
            List<Tombstone> previousTombstones = previous.tombstones;
            List<Tombstone> currentTombstones = current.tombstones;
            if (previousTombstones.isEmpty()) {
                added = new ArrayList<Tombstone>(currentTombstones);
                removed = 0;
            } else if (currentTombstones.isEmpty()) {
                added = Collections.emptyList();
                removed = previousTombstones.size();
            } else {
                Tombstone lastAddedTombstone = previousTombstones.get(previousTombstones.size() - 1);
                int addedIndex = currentTombstones.lastIndexOf(lastAddedTombstone);
                added = addedIndex < currentTombstones.size() ? currentTombstones.subList(addedIndex + 1, currentTombstones.size()) : Collections.emptyList();
                Tombstone firstTombstone = currentTombstones.get(0);
                int idx = previousTombstones.indexOf(firstTombstone);
                if (idx < 0) {
                    assert (added.equals(currentTombstones));
                    idx = previousTombstones.size();
                }
                removed = idx;
            }
            this.added = Collections.unmodifiableList(added);
            this.removedCount = removed;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeList(this.added);
            out.writeVInt(this.removedCount);
        }

        @Override
        public IndexGraveyard apply(Metadata.Custom previous) {
            IndexGraveyard old = (IndexGraveyard)previous;
            if (this.removedCount > old.tombstones.size()) {
                throw new IllegalStateException("IndexGraveyardDiff cannot remove [" + this.removedCount + "] entries from [" + old.tombstones.size() + "] tombstones.");
            }
            ArrayList<Tombstone> newTombstones = new ArrayList<Tombstone>(old.tombstones.subList(this.removedCount, old.tombstones.size()));
            for (Tombstone tombstone : this.added) {
                newTombstones.add(tombstone);
            }
            return new Builder().addBuiltTombstones(newTombstones).build();
        }

        public List<Tombstone> getAdded() {
            return this.added;
        }

        public int getRemovedCount() {
            return this.removedCount;
        }

        @Override
        public String getWriteableName() {
            return IndexGraveyard.TYPE;
        }
    }

    public static final class Builder {
        private List<Tombstone> tombstones;
        private int numPurged = -1;
        private final long currentTime = System.currentTimeMillis();

        private Builder() {
            this.tombstones = new ArrayList<Tombstone>();
        }

        private Builder(IndexGraveyard that) {
            this.tombstones = new ArrayList<Tombstone>(that.getTombstones());
        }

        public List<Tombstone> tombstones() {
            return Collections.unmodifiableList(this.tombstones);
        }

        public Builder addTombstone(Index index) {
            this.tombstones.add(new Tombstone(index, this.currentTime));
            return this;
        }

        public Builder addTombstones(Collection<Index> indices) {
            for (Index index : indices) {
                this.addTombstone(index);
            }
            return this;
        }

        Builder addBuiltTombstones(List<Tombstone> tombstones) {
            this.tombstones.addAll(tombstones);
            return this;
        }

        public int getNumPurged() {
            assert (this.numPurged != -1);
            return this.numPurged;
        }

        private int purge(int maxTombstones) {
            int count = this.tombstones().size() - maxTombstones;
            if (count <= 0) {
                return 0;
            }
            this.tombstones = this.tombstones.subList(count, this.tombstones.size());
            return count;
        }

        public IndexGraveyard build() {
            return this.build(Settings.EMPTY);
        }

        public IndexGraveyard build(Settings settings) {
            this.numPurged = this.purge(SETTING_MAX_TOMBSTONES.get(settings));
            return new IndexGraveyard(this.tombstones);
        }
    }
}

