/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.client.security;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.easysearch.client.security.user.User;
import org.easysearch.client.security.user.parser.UserJsonParser;
import org.easysearch.common.util.JsonUtils;
import org.easysearch.common.xcontent.XContentParser;

public class GetUsersResponse {
    private final Set<User> users;

    public GetUsersResponse(Set<User> users) {
        this.users = Collections.unmodifiableSet(users);
    }

    public Set<User> getUsers() {
        return this.users;
    }

    public static GetUsersResponse fromXContent(XContentParser parser) throws IOException {
        Set<User> users = UserJsonParser.parseUsers(parser);
        return new GetUsersResponse(users);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetUsersResponse)) {
            return false;
        }
        GetUsersResponse that = (GetUsersResponse)o;
        return Objects.equals(this.users, that.users);
    }

    public int hashCode() {
        return Objects.hash(this.users);
    }

    public String toJson() {
        ObjectNode rootNode = JsonUtils.objectMapper.createObjectNode();
        for (User user : this.users) {
            JsonNode roleNode = JsonUtils.objectMapper.valueToTree((Object)user);
            rootNode.set(user.getName(), roleNode);
        }
        return JsonUtils.writeObjectAsString(rootNode);
    }
}

