/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.client.security;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Set;
import org.easysearch.client.security.user.Role;
import org.easysearch.client.security.user.parser.RoleJsonParser;
import org.easysearch.common.util.JsonUtils;
import org.easysearch.common.xcontent.XContentParser;

public class GetRolesResponse {
    private final Set<Role> roles;

    public GetRolesResponse(Set<Role> roles) {
        this.roles = roles;
    }

    public Set<Role> getRoles() {
        return this.roles;
    }

    public static GetRolesResponse fromXContent(XContentParser parser) throws IOException {
        Set<Role> roles = RoleJsonParser.parseRoles(parser);
        return new GetRolesResponse(roles);
    }

    public String toJson() {
        ObjectNode rootNode = JsonUtils.objectMapper.createObjectNode();
        for (Role role : this.roles) {
            JsonNode roleNode = JsonUtils.objectMapper.valueToTree((Object)role);
            rootNode.set(role.getName(), roleNode);
        }
        return JsonUtils.writeObjectAsString(rootNode);
    }
}

