/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.client.indexlifecycle;

import java.io.IOException;
import java.util.Objects;
import org.easysearch.client.indexlifecycle.LifecycleAction;
import org.easysearch.common.ParseField;
import org.easysearch.common.Strings;
import org.easysearch.common.xcontent.ConstructingObjectParser;
import org.easysearch.common.xcontent.ToXContent;
import org.easysearch.common.xcontent.ToXContentObject;
import org.easysearch.common.xcontent.XContentBuilder;
import org.easysearch.common.xcontent.XContentParser;

public class ShrinkAction
implements LifecycleAction,
ToXContentObject {
    public static final String NAME = "shrink";
    private static final ParseField NUMBER_OF_SHARDS_FIELD = new ParseField("number_of_shards", new String[0]);
    private static final ConstructingObjectParser<ShrinkAction, Void> PARSER = new ConstructingObjectParser("shrink", true, a -> new ShrinkAction((Integer)a[0]));
    private int numberOfShards;

    public static ShrinkAction parse(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    public ShrinkAction(int numberOfShards) {
        if (numberOfShards <= 0) {
            throw new IllegalArgumentException("[" + NUMBER_OF_SHARDS_FIELD.getPreferredName() + "] must be greater than 0");
        }
        this.numberOfShards = numberOfShards;
    }

    int getNumberOfShards() {
        return this.numberOfShards;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NUMBER_OF_SHARDS_FIELD.getPreferredName(), this.numberOfShards);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShrinkAction that = (ShrinkAction)o;
        return Objects.equals(this.numberOfShards, that.numberOfShards);
    }

    public int hashCode() {
        return Objects.hash(this.numberOfShards);
    }

    public String toString() {
        return Strings.toString(this);
    }

    static {
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), NUMBER_OF_SHARDS_FIELD);
    }
}

