/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.client;

import java.io.IOException;
import java.util.Collections;
import org.easysearch.client.RequestOptions;
import org.easysearch.client.RestHighLevelClient;
import org.easysearch.client.SecurityRequestConverters;
import org.easysearch.client.security.ChangePasswordRequest;
import org.easysearch.client.security.DeletePrivilegeResponse;
import org.easysearch.client.security.DeletePrivilegesRequest;
import org.easysearch.client.security.DeleteRoleMappingRequest;
import org.easysearch.client.security.DeleteRoleMappingResponse;
import org.easysearch.client.security.DeleteRoleRequest;
import org.easysearch.client.security.DeleteRoleResponse;
import org.easysearch.client.security.DeleteUserRequest;
import org.easysearch.client.security.DeleteUserResponse;
import org.easysearch.client.security.GetAccountRequest;
import org.easysearch.client.security.GetAccountResponse;
import org.easysearch.client.security.GetPrivilegesRequest;
import org.easysearch.client.security.GetPrivilegesResponse;
import org.easysearch.client.security.GetRoleMappingsRequest;
import org.easysearch.client.security.GetRoleMappingsResponse;
import org.easysearch.client.security.GetRolesRequest;
import org.easysearch.client.security.GetRolesResponse;
import org.easysearch.client.security.GetSslCertificatesRequest;
import org.easysearch.client.security.GetSslCertificatesResponse;
import org.easysearch.client.security.GetUsersRequest;
import org.easysearch.client.security.GetUsersResponse;
import org.easysearch.client.security.PutPrivilegeRequest;
import org.easysearch.client.security.PutPrivilegeResponse;
import org.easysearch.client.security.PutRoleMappingRequest;
import org.easysearch.client.security.PutRoleMappingResponse;
import org.easysearch.client.security.PutRoleRequest;
import org.easysearch.client.security.PutRoleResponse;
import org.easysearch.client.security.PutUserRequest;
import org.easysearch.client.security.PutUserResponse;

public final class SecurityClient {
    private final RestHighLevelClient restHighLevelClient;

    SecurityClient(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    public GetAccountResponse getAccount() throws IOException {
        GetAccountRequest getAccountRequest = new GetAccountRequest();
        RequestOptions options = RequestOptions.DEFAULT;
        return this.restHighLevelClient.performRequestAndParseEntity(getAccountRequest, SecurityRequestConverters::getAccount, options, GetAccountResponse::fromXContent, Collections.emptySet());
    }

    public GetUsersResponse getUsers(GetUsersRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::getUsers, options, GetUsersResponse::fromXContent, Collections.emptySet());
    }

    public PutUserResponse putUser(PutUserRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::putUser, options, PutUserResponse::fromXContent, Collections.emptySet());
    }

    public DeleteUserResponse deleteUser(DeleteUserRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::deleteUser, options, DeleteUserResponse::fromXContent, Collections.singleton(404));
    }

    public PutRoleMappingResponse putRoleMapping(PutRoleMappingRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::putRoleMapping, options, PutRoleMappingResponse::fromXContent, Collections.emptySet());
    }

    public GetRoleMappingsResponse getRoleMappings(GetRoleMappingsRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::getRoleMappings, options, GetRoleMappingsResponse::fromXContent, Collections.emptySet());
    }

    public GetSslCertificatesResponse getSslCertificates(RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(GetSslCertificatesRequest.INSTANCE, GetSslCertificatesRequest::getRequest, options, GetSslCertificatesResponse::fromXContent, Collections.emptySet());
    }

    public boolean changePassword(ChangePasswordRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequest(request, SecurityRequestConverters::changePassword, options, RestHighLevelClient::convertExistsResponse, Collections.emptySet());
    }

    public DeleteRoleMappingResponse deleteRoleMapping(DeleteRoleMappingRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::deleteRoleMapping, options, DeleteRoleMappingResponse::fromXContent, Collections.singleton(404));
    }

    public GetRolesResponse getRoles(GetRolesRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::getRoles, options, GetRolesResponse::fromXContent, Collections.emptySet());
    }

    public PutRoleResponse putRole(PutRoleRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::putRole, options, PutRoleResponse::fromXContent, Collections.emptySet());
    }

    public DeleteRoleResponse deleteRole(DeleteRoleRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::deleteRole, options, DeleteRoleResponse::fromXContent, Collections.singleton(404));
    }

    public GetPrivilegesResponse getPrivileges(GetPrivilegesRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::getPrivileges, options, GetPrivilegesResponse::fromXContent, Collections.emptySet());
    }

    public PutPrivilegeResponse putPrivileges(PutPrivilegeRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::putPrivileges, options, PutPrivilegeResponse::fromXContent, Collections.emptySet());
    }

    public DeletePrivilegeResponse deletePrivilege(DeletePrivilegesRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::deletePrivileges, options, DeletePrivilegeResponse::fromXContent, Collections.singleton(404));
    }
}

