/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.client;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.apache.http.HttpHost;

public class Node {
    private final HttpHost host;
    private final Set<HttpHost> boundHosts;
    private final String name;
    private final String version;
    private final Roles roles;
    private final Map<String, List<String>> attributes;

    public Node(HttpHost host, Set<HttpHost> boundHosts, String name, String version, Roles roles, Map<String, List<String>> attributes) {
        if (host == null) {
            throw new IllegalArgumentException("host cannot be null");
        }
        this.host = host;
        this.boundHosts = boundHosts;
        this.name = name;
        this.version = version;
        this.roles = roles;
        this.attributes = attributes;
    }

    public Node(HttpHost host) {
        this(host, null, null, null, null, null);
    }

    public HttpHost getHost() {
        return this.host;
    }

    public Set<HttpHost> getBoundHosts() {
        return this.boundHosts;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public Roles getRoles() {
        return this.roles;
    }

    public Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("[host=").append(this.host);
        if (this.boundHosts != null) {
            b.append(", bound=").append(this.boundHosts);
        }
        if (this.name != null) {
            b.append(", name=").append(this.name);
        }
        if (this.version != null) {
            b.append(", version=").append(this.version);
        }
        if (this.roles != null) {
            b.append(", roles=").append(this.roles);
        }
        if (this.attributes != null) {
            b.append(", attributes=").append(this.attributes);
        }
        return b.append(']').toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Node other = (Node)obj;
        return this.host.equals(other.host) && Objects.equals(this.boundHosts, other.boundHosts) && Objects.equals(this.name, other.name) && Objects.equals(this.version, other.version) && Objects.equals(this.roles, other.roles) && Objects.equals(this.attributes, other.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.boundHosts, this.name, this.version, this.roles, this.attributes);
    }

    public static final class Roles {
        private final Set<String> roles;

        public Roles(Set<String> roles) {
            this.roles = new TreeSet<String>(roles);
        }

        public boolean isMasterEligible() {
            return this.roles.contains("master");
        }

        public boolean isData() {
            return this.roles.contains("data");
        }

        public boolean isIngest() {
            return this.roles.contains("ingest");
        }

        public String toString() {
            return String.join((CharSequence)",", this.roles);
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Roles other = (Roles)obj;
            return this.roles.equals(other.roles);
        }

        public int hashCode() {
            return this.roles.hashCode();
        }
    }
}

