/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.client;

import java.io.IOException;
import java.util.Collections;
import org.easysearch.action.ActionListener;
import org.easysearch.client.AsyncSearchRequestConverters;
import org.easysearch.client.Cancellable;
import org.easysearch.client.RequestOptions;
import org.easysearch.client.RestHighLevelClient;
import org.easysearch.client.asyncsearch.AsyncSearchResponse;
import org.easysearch.client.asyncsearch.DeleteAsyncSearchRequest;
import org.easysearch.client.asyncsearch.GetAsyncSearchRequest;
import org.easysearch.client.asyncsearch.SubmitAsyncSearchRequest;
import org.easysearch.client.core.AcknowledgedResponse;

public class AsyncSearchClient {
    private final RestHighLevelClient restHighLevelClient;

    AsyncSearchClient(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    public AsyncSearchResponse submit(SubmitAsyncSearchRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, AsyncSearchRequestConverters::submitAsyncSearch, options, AsyncSearchResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable submitAsync(SubmitAsyncSearchRequest request, RequestOptions options, ActionListener<AsyncSearchResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, AsyncSearchRequestConverters::submitAsyncSearch, options, AsyncSearchResponse::fromXContent, listener, Collections.emptySet());
    }

    public AsyncSearchResponse get(GetAsyncSearchRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, AsyncSearchRequestConverters::getAsyncSearch, options, AsyncSearchResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable getAsync(GetAsyncSearchRequest request, RequestOptions options, ActionListener<AsyncSearchResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, AsyncSearchRequestConverters::getAsyncSearch, options, AsyncSearchResponse::fromXContent, listener, Collections.emptySet());
    }

    public AcknowledgedResponse delete(DeleteAsyncSearchRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, AsyncSearchRequestConverters::deleteAsyncSearch, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable deleteAsync(DeleteAsyncSearchRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, AsyncSearchRequestConverters::deleteAsyncSearch, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }
}

