/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.termvectors;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.easysearch.action.ActionListener;
import org.easysearch.action.RoutingMissingException;
import org.easysearch.action.support.ActionFilters;
import org.easysearch.action.support.HandledTransportAction;
import org.easysearch.action.termvectors.MultiTermVectorsItemResponse;
import org.easysearch.action.termvectors.MultiTermVectorsRequest;
import org.easysearch.action.termvectors.MultiTermVectorsResponse;
import org.easysearch.action.termvectors.MultiTermVectorsShardRequest;
import org.easysearch.action.termvectors.MultiTermVectorsShardResponse;
import org.easysearch.action.termvectors.TermVectorsRequest;
import org.easysearch.action.termvectors.TransportShardMultiTermsVectorAction;
import org.easysearch.cluster.ClusterState;
import org.easysearch.cluster.block.ClusterBlockLevel;
import org.easysearch.cluster.metadata.IndexNameExpressionResolver;
import org.easysearch.cluster.service.ClusterService;
import org.easysearch.common.inject.Inject;
import org.easysearch.common.util.concurrent.AtomicArray;
import org.easysearch.index.IndexNotFoundException;
import org.easysearch.index.shard.ShardId;
import org.easysearch.tasks.Task;
import org.easysearch.transport.TransportService;

public class TransportMultiTermVectorsAction
extends HandledTransportAction<MultiTermVectorsRequest, MultiTermVectorsResponse> {
    private final ClusterService clusterService;
    private final TransportShardMultiTermsVectorAction shardAction;
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    @Inject
    public TransportMultiTermVectorsAction(TransportService transportService, ClusterService clusterService, TransportShardMultiTermsVectorAction shardAction, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:data/read/mtv", transportService, actionFilters, MultiTermVectorsRequest::new);
        this.clusterService = clusterService;
        this.shardAction = shardAction;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
    }

    @Override
    protected void doExecute(Task task, MultiTermVectorsRequest request, ActionListener<MultiTermVectorsResponse> listener) {
        ClusterState clusterState = this.clusterService.state();
        clusterState.blocks().globalBlockedRaiseException(ClusterBlockLevel.READ);
        AtomicArray<MultiTermVectorsItemResponse> responses = new AtomicArray<MultiTermVectorsItemResponse>(request.requests.size());
        HashMap<ShardId, MultiTermVectorsShardRequest> shardRequests = new HashMap<ShardId, MultiTermVectorsShardRequest>();
        for (int i = 0; i < request.requests.size(); ++i) {
            TermVectorsRequest termVectorsRequest = request.requests.get(i);
            termVectorsRequest.routing(clusterState.metadata().resolveIndexRouting(termVectorsRequest.routing(), termVectorsRequest.index()));
            if (!clusterState.metadata().hasConcreteIndex(termVectorsRequest.index())) {
                responses.set(i, new MultiTermVectorsItemResponse(null, new MultiTermVectorsResponse.Failure(termVectorsRequest.index(), termVectorsRequest.type(), termVectorsRequest.id(), new IndexNotFoundException(termVectorsRequest.index()))));
                continue;
            }
            String concreteSingleIndex = this.indexNameExpressionResolver.concreteSingleIndex(clusterState, termVectorsRequest).getName();
            if (termVectorsRequest.routing() == null && clusterState.getMetadata().routingRequired(concreteSingleIndex)) {
                responses.set(i, new MultiTermVectorsItemResponse(null, new MultiTermVectorsResponse.Failure(concreteSingleIndex, termVectorsRequest.type(), termVectorsRequest.id(), new RoutingMissingException(concreteSingleIndex, termVectorsRequest.type(), termVectorsRequest.id()))));
                continue;
            }
            ShardId shardId = this.clusterService.operationRouting().shardId(clusterState, concreteSingleIndex, termVectorsRequest.id(), termVectorsRequest.routing());
            MultiTermVectorsShardRequest shardRequest = (MultiTermVectorsShardRequest)shardRequests.get(shardId);
            if (shardRequest == null) {
                shardRequest = new MultiTermVectorsShardRequest(shardId.getIndexName(), shardId.id());
                shardRequest.preference(request.preference);
                shardRequests.put(shardId, shardRequest);
            }
            shardRequest.add(i, termVectorsRequest);
        }
        if (shardRequests.size() == 0) {
            listener.onResponse(new MultiTermVectorsResponse(responses.toArray((MultiTermVectorsItemResponse[])new MultiTermVectorsItemResponse[responses.length()])));
        }
        this.executeShardAction(listener, responses, shardRequests);
    }

    protected void executeShardAction(final ActionListener<MultiTermVectorsResponse> listener, final AtomicArray<MultiTermVectorsItemResponse> responses, Map<ShardId, MultiTermVectorsShardRequest> shardRequests) {
        final AtomicInteger counter = new AtomicInteger(shardRequests.size());
        for (final MultiTermVectorsShardRequest shardRequest : shardRequests.values()) {
            this.shardAction.execute(shardRequest, new ActionListener<MultiTermVectorsShardResponse>(){

                @Override
                public void onResponse(MultiTermVectorsShardResponse response) {
                    for (int i = 0; i < response.locations.size(); ++i) {
                        responses.set(response.locations.get(i), new MultiTermVectorsItemResponse(response.responses.get(i), response.failures.get(i)));
                    }
                    if (counter.decrementAndGet() == 0) {
                        this.finishHim();
                    }
                }

                @Override
                public void onFailure(Exception e) {
                    for (int i = 0; i < shardRequest.locations.size(); ++i) {
                        TermVectorsRequest termVectorsRequest = shardRequest.requests.get(i);
                        responses.set(shardRequest.locations.get(i), new MultiTermVectorsItemResponse(null, new MultiTermVectorsResponse.Failure(shardRequest.index(), termVectorsRequest.type(), termVectorsRequest.id(), e)));
                    }
                    if (counter.decrementAndGet() == 0) {
                        this.finishHim();
                    }
                }

                private void finishHim() {
                    listener.onResponse(new MultiTermVectorsResponse(responses.toArray(new MultiTermVectorsItemResponse[responses.length()])));
                }
            });
        }
    }
}

