/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.search;

import org.easysearch.action.ActionListener;
import org.easysearch.action.search.ParsedScrollId;
import org.easysearch.action.search.SearchPhaseController;
import org.easysearch.action.search.SearchResponse;
import org.easysearch.action.search.SearchScrollAsyncAction;
import org.easysearch.action.search.SearchScrollQueryAndFetchAsyncAction;
import org.easysearch.action.search.SearchScrollQueryThenFetchAsyncAction;
import org.easysearch.action.search.SearchScrollRequest;
import org.easysearch.action.search.SearchTask;
import org.easysearch.action.search.SearchTransportService;
import org.easysearch.action.search.TransportSearchHelper;
import org.easysearch.action.support.ActionFilters;
import org.easysearch.action.support.HandledTransportAction;
import org.easysearch.cluster.service.ClusterService;
import org.easysearch.common.inject.Inject;
import org.easysearch.tasks.Task;
import org.easysearch.transport.TransportService;

public class TransportSearchScrollAction
extends HandledTransportAction<SearchScrollRequest, SearchResponse> {
    private final ClusterService clusterService;
    private final SearchTransportService searchTransportService;
    private final SearchPhaseController searchPhaseController;

    @Inject
    public TransportSearchScrollAction(TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, SearchTransportService searchTransportService, SearchPhaseController searchPhaseController) {
        super("indices:data/read/scroll", transportService, actionFilters, SearchScrollRequest::new);
        this.clusterService = clusterService;
        this.searchTransportService = searchTransportService;
        this.searchPhaseController = searchPhaseController;
    }

    @Override
    protected void doExecute(Task task, SearchScrollRequest request, ActionListener<SearchResponse> listener) {
        try {
            SearchScrollAsyncAction action;
            ParsedScrollId scrollId = TransportSearchHelper.parseScrollId(request.scrollId());
            switch (scrollId.getType()) {
                case "queryThenFetch": {
                    action = new SearchScrollQueryThenFetchAsyncAction(this.logger, this.clusterService, this.searchTransportService, this.searchPhaseController, request, (SearchTask)task, scrollId, listener);
                    break;
                }
                case "queryAndFetch": {
                    action = new SearchScrollQueryAndFetchAsyncAction(this.logger, this.clusterService, this.searchTransportService, this.searchPhaseController, request, (SearchTask)task, scrollId, listener);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Scroll id type [" + scrollId.getType() + "] unrecognized");
                }
            }
            action.run();
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }
}

