/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.search;

import java.util.concurrent.Executor;
import org.apache.logging.log4j.Logger;
import org.easysearch.action.OriginalIndices;
import org.easysearch.action.search.SearchPhase;
import org.easysearch.action.search.SearchRequest;
import org.easysearch.action.search.SearchShardIterator;
import org.easysearch.action.search.SearchTask;
import org.easysearch.action.search.SearchTransportService;
import org.easysearch.common.Nullable;
import org.easysearch.common.lease.Releasable;
import org.easysearch.common.util.concurrent.AtomicArray;
import org.easysearch.search.SearchPhaseResult;
import org.easysearch.search.SearchShardTarget;
import org.easysearch.search.internal.InternalSearchResponse;
import org.easysearch.search.internal.ShardSearchContextId;
import org.easysearch.search.internal.ShardSearchRequest;
import org.easysearch.transport.Transport;

interface SearchPhaseContext
extends Executor {
    public int getNumShards();

    public Logger getLogger();

    public SearchTask getTask();

    public SearchRequest getRequest();

    public void sendSearchResponse(InternalSearchResponse var1, AtomicArray<SearchPhaseResult> var2);

    public void onFailure(Exception var1);

    public void onPhaseFailure(SearchPhase var1, String var2, Throwable var3);

    public void onShardFailure(int var1, @Nullable SearchShardTarget var2, Exception var3);

    public Transport.Connection getConnection(String var1, String var2);

    public SearchTransportService getSearchTransport();

    default public void sendReleaseSearchContext(ShardSearchContextId contextId, Transport.Connection connection, OriginalIndices originalIndices) {
        if (connection != null) {
            this.getSearchTransport().sendFreeContext(connection, contextId, originalIndices);
        }
    }

    public ShardSearchRequest buildShardSearchRequest(SearchShardIterator var1);

    public void executeNextPhase(SearchPhase var1, SearchPhase var2);

    public void addReleasable(Releasable var1);
}

