/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.search;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import org.apache.logging.log4j.Logger;
import org.easysearch.action.ActionListener;
import org.easysearch.action.search.AbstractSearchAsyncAction;
import org.easysearch.action.search.ArraySearchPhaseResults;
import org.easysearch.action.search.DfsQueryPhase;
import org.easysearch.action.search.FetchSearchPhase;
import org.easysearch.action.search.QueryPhaseResultConsumer;
import org.easysearch.action.search.SearchActionListener;
import org.easysearch.action.search.SearchPhase;
import org.easysearch.action.search.SearchPhaseContext;
import org.easysearch.action.search.SearchPhaseController;
import org.easysearch.action.search.SearchPhaseResults;
import org.easysearch.action.search.SearchProgressListener;
import org.easysearch.action.search.SearchRequest;
import org.easysearch.action.search.SearchResponse;
import org.easysearch.action.search.SearchShardIterator;
import org.easysearch.action.search.SearchTask;
import org.easysearch.action.search.SearchTransportService;
import org.easysearch.action.search.TransportSearchAction;
import org.easysearch.cluster.ClusterState;
import org.easysearch.cluster.routing.GroupShardsIterator;
import org.easysearch.search.SearchPhaseResult;
import org.easysearch.search.SearchShardTarget;
import org.easysearch.search.builder.SearchSourceBuilder;
import org.easysearch.search.dfs.AggregatedDfs;
import org.easysearch.search.dfs.DfsSearchResult;
import org.easysearch.search.internal.AliasFilter;
import org.easysearch.transport.Transport;

final class SearchDfsQueryThenFetchAsyncAction
extends AbstractSearchAsyncAction<DfsSearchResult> {
    private final SearchPhaseController searchPhaseController;
    private final QueryPhaseResultConsumer queryPhaseResultConsumer;

    SearchDfsQueryThenFetchAsyncAction(Logger logger, SearchTransportService searchTransportService, BiFunction<String, String, Transport.Connection> nodeIdToConnection, Map<String, AliasFilter> aliasFilter, Map<String, Float> concreteIndexBoosts, Map<String, Set<String>> indexRoutings, SearchPhaseController searchPhaseController, Executor executor, QueryPhaseResultConsumer queryPhaseResultConsumer, SearchRequest request, ActionListener<SearchResponse> listener, GroupShardsIterator<SearchShardIterator> shardsIts, TransportSearchAction.SearchTimeProvider timeProvider, ClusterState clusterState, SearchTask task, SearchResponse.Clusters clusters) {
        super("dfs", logger, searchTransportService, nodeIdToConnection, aliasFilter, concreteIndexBoosts, indexRoutings, executor, request, listener, shardsIts, timeProvider, clusterState, task, new ArraySearchPhaseResults(shardsIts.size()), request.getMaxConcurrentShardRequests(), clusters);
        this.queryPhaseResultConsumer = queryPhaseResultConsumer;
        this.searchPhaseController = searchPhaseController;
        SearchProgressListener progressListener = task.getProgressListener();
        SearchSourceBuilder sourceBuilder = request.source();
        progressListener.notifyListShards(SearchProgressListener.buildSearchShards(this.shardsIts), SearchProgressListener.buildSearchShards(this.toSkipShardsIts), clusters, sourceBuilder == null || sourceBuilder.size() != 0);
    }

    @Override
    protected void executePhaseOnShard(SearchShardIterator shardIt, SearchShardTarget shard, SearchActionListener<DfsSearchResult> listener) {
        this.getSearchTransport().sendExecuteDfs(this.getConnection(shard.getClusterAlias(), shard.getNodeId()), this.buildShardSearchRequest(shardIt), this.getTask(), listener);
    }

    @Override
    protected SearchPhase getNextPhase(SearchPhaseResults<DfsSearchResult> results, SearchPhaseContext context) {
        List<DfsSearchResult> dfsSearchResults = results.getAtomicArray().asList();
        AggregatedDfs aggregatedDfs = this.searchPhaseController.aggregateDfs(dfsSearchResults);
        return new DfsQueryPhase(dfsSearchResults, aggregatedDfs, this.queryPhaseResultConsumer, queryResults -> new FetchSearchPhase((SearchPhaseResults<SearchPhaseResult>)queryResults, this.searchPhaseController, aggregatedDfs, context), context);
    }
}

