/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.ingest;

import java.util.Map;
import org.easysearch.action.ActionListener;
import org.easysearch.action.ingest.SimulateExecutionService;
import org.easysearch.action.ingest.SimulatePipelineRequest;
import org.easysearch.action.ingest.SimulatePipelineResponse;
import org.easysearch.action.support.ActionFilters;
import org.easysearch.action.support.HandledTransportAction;
import org.easysearch.common.inject.Inject;
import org.easysearch.common.xcontent.XContentHelper;
import org.easysearch.ingest.IngestService;
import org.easysearch.tasks.Task;
import org.easysearch.threadpool.ThreadPool;
import org.easysearch.transport.TransportService;

public class SimulatePipelineTransportAction
extends HandledTransportAction<SimulatePipelineRequest, SimulatePipelineResponse> {
    private final IngestService ingestService;
    private final SimulateExecutionService executionService;

    @Inject
    public SimulatePipelineTransportAction(ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IngestService ingestService) {
        super("cluster:admin/ingest/pipeline/simulate", transportService, actionFilters, SimulatePipelineRequest::new);
        this.ingestService = ingestService;
        this.executionService = new SimulateExecutionService(threadPool);
    }

    @Override
    protected void doExecute(Task task, SimulatePipelineRequest request, ActionListener<SimulatePipelineResponse> listener) {
        SimulatePipelineRequest.Parsed simulateRequest;
        Map<String, Object> source = XContentHelper.convertToMap(request.getSource(), false, request.getXContentType()).v2();
        try {
            simulateRequest = request.getId() != null ? SimulatePipelineRequest.parseWithPipelineId(request.getId(), source, request.isVerbose(), this.ingestService) : SimulatePipelineRequest.parse(source, request.isVerbose(), this.ingestService);
        }
        catch (Exception e) {
            listener.onFailure(e);
            return;
        }
        this.executionService.execute(simulateRequest, listener);
    }
}

