/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.ingest;

import java.io.IOException;
import java.util.Objects;
import org.easysearch.action.ActionRequestValidationException;
import org.easysearch.action.support.master.AcknowledgedRequest;
import org.easysearch.common.bytes.BytesReference;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.common.xcontent.ToXContent;
import org.easysearch.common.xcontent.ToXContentObject;
import org.easysearch.common.xcontent.XContentBuilder;
import org.easysearch.common.xcontent.XContentType;

public class PutPipelineRequest
extends AcknowledgedRequest<PutPipelineRequest>
implements ToXContentObject {
    private String id;
    private BytesReference source;
    private XContentType xContentType;

    public PutPipelineRequest(String id, BytesReference source, XContentType xContentType) {
        this.id = Objects.requireNonNull(id);
        this.source = Objects.requireNonNull(source);
        this.xContentType = Objects.requireNonNull(xContentType);
    }

    public PutPipelineRequest(StreamInput in) throws IOException {
        super(in);
        this.id = in.readString();
        this.source = in.readBytesReference();
        this.xContentType = in.readEnum(XContentType.class);
    }

    PutPipelineRequest() {
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    public String getId() {
        return this.id;
    }

    public BytesReference getSource() {
        return this.source;
    }

    public XContentType getXContentType() {
        return this.xContentType;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.id);
        out.writeBytesReference(this.source);
        out.writeEnum(this.xContentType);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.source != null) {
            builder.rawValue(this.source.streamInput(), this.xContentType);
        } else {
            builder.startObject().endObject();
        }
        return builder;
    }
}

