/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.get;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.easysearch.action.ActionListener;
import org.easysearch.action.RoutingMissingException;
import org.easysearch.action.get.MultiGetItemResponse;
import org.easysearch.action.get.MultiGetRequest;
import org.easysearch.action.get.MultiGetResponse;
import org.easysearch.action.get.MultiGetShardRequest;
import org.easysearch.action.get.MultiGetShardResponse;
import org.easysearch.action.get.TransportShardMultiGetAction;
import org.easysearch.action.support.ActionFilters;
import org.easysearch.action.support.HandledTransportAction;
import org.easysearch.cluster.ClusterState;
import org.easysearch.cluster.block.ClusterBlockLevel;
import org.easysearch.cluster.metadata.IndexNameExpressionResolver;
import org.easysearch.cluster.service.ClusterService;
import org.easysearch.common.inject.Inject;
import org.easysearch.common.util.concurrent.AtomicArray;
import org.easysearch.index.shard.ShardId;
import org.easysearch.tasks.Task;
import org.easysearch.transport.TransportService;

public class TransportMultiGetAction
extends HandledTransportAction<MultiGetRequest, MultiGetResponse> {
    private final ClusterService clusterService;
    private final TransportShardMultiGetAction shardAction;
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    @Inject
    public TransportMultiGetAction(TransportService transportService, ClusterService clusterService, TransportShardMultiGetAction shardAction, ActionFilters actionFilters, IndexNameExpressionResolver resolver) {
        super("indices:data/read/mget", transportService, actionFilters, MultiGetRequest::new);
        this.clusterService = clusterService;
        this.shardAction = shardAction;
        this.indexNameExpressionResolver = resolver;
    }

    @Override
    protected void doExecute(Task task, MultiGetRequest request, ActionListener<MultiGetResponse> listener) {
        ClusterState clusterState = this.clusterService.state();
        clusterState.blocks().globalBlockedRaiseException(ClusterBlockLevel.READ);
        AtomicArray<MultiGetItemResponse> responses = new AtomicArray<MultiGetItemResponse>(request.items.size());
        HashMap<ShardId, MultiGetShardRequest> shardRequests = new HashMap<ShardId, MultiGetShardRequest>();
        for (int i = 0; i < request.items.size(); ++i) {
            String concreteSingleIndex;
            MultiGetRequest.Item item;
            block6: {
                item = request.items.get(i);
                try {
                    concreteSingleIndex = this.indexNameExpressionResolver.concreteSingleIndex(clusterState, item).getName();
                    item.routing(clusterState.metadata().resolveIndexRouting(item.routing(), item.index()));
                    if (item.routing() == null && clusterState.getMetadata().routingRequired(concreteSingleIndex)) {
                        responses.set(i, TransportMultiGetAction.newItemFailure(concreteSingleIndex, item.type(), item.id(), new RoutingMissingException(concreteSingleIndex, item.type(), item.id())));
                    }
                    break block6;
                }
                catch (Exception e) {
                    responses.set(i, TransportMultiGetAction.newItemFailure(item.index(), item.type(), item.id(), e));
                }
                continue;
            }
            ShardId shardId = this.clusterService.operationRouting().getShards(clusterState, concreteSingleIndex, item.id(), item.routing(), null).shardId();
            MultiGetShardRequest shardRequest = (MultiGetShardRequest)shardRequests.get(shardId);
            if (shardRequest == null) {
                shardRequest = new MultiGetShardRequest(request, shardId.getIndexName(), shardId.getId());
                shardRequests.put(shardId, shardRequest);
            }
            shardRequest.add(i, item);
        }
        if (shardRequests.isEmpty()) {
            listener.onResponse(new MultiGetResponse(responses.toArray((MultiGetItemResponse[])new MultiGetItemResponse[responses.length()])));
        }
        this.executeShardAction(listener, responses, shardRequests);
    }

    protected void executeShardAction(final ActionListener<MultiGetResponse> listener, final AtomicArray<MultiGetItemResponse> responses, Map<ShardId, MultiGetShardRequest> shardRequests) {
        final AtomicInteger counter = new AtomicInteger(shardRequests.size());
        for (final MultiGetShardRequest shardRequest : shardRequests.values()) {
            this.shardAction.execute(shardRequest, new ActionListener<MultiGetShardResponse>(){

                @Override
                public void onResponse(MultiGetShardResponse response) {
                    for (int i = 0; i < response.locations.size(); ++i) {
                        MultiGetItemResponse itemResponse = new MultiGetItemResponse(response.responses.get(i), response.failures.get(i));
                        responses.set(response.locations.get(i), itemResponse);
                    }
                    if (counter.decrementAndGet() == 0) {
                        this.finishHim();
                    }
                }

                @Override
                public void onFailure(Exception e) {
                    for (int i = 0; i < shardRequest.locations.size(); ++i) {
                        MultiGetRequest.Item item = shardRequest.items.get(i);
                        responses.set(shardRequest.locations.get(i), TransportMultiGetAction.newItemFailure(shardRequest.index(), item.type(), item.id(), e));
                    }
                    if (counter.decrementAndGet() == 0) {
                        this.finishHim();
                    }
                }

                private void finishHim() {
                    listener.onResponse(new MultiGetResponse(responses.toArray(new MultiGetItemResponse[responses.length()])));
                }
            });
        }
    }

    private static MultiGetItemResponse newItemFailure(String index, String type, String id, Exception exception) {
        return new MultiGetItemResponse(null, new MultiGetResponse.Failure(index, type, id, exception));
    }
}

