/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.admin.indices.stats;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.easysearch.action.admin.indices.stats.CommonStats;
import org.easysearch.action.admin.indices.stats.IndexShardStats;
import org.easysearch.action.admin.indices.stats.ShardStats;

public class IndexStats
implements Iterable<IndexShardStats> {
    private final String index;
    private final String uuid;
    private final ShardStats[] shards;
    private Map<Integer, IndexShardStats> indexShards;
    private CommonStats total = null;
    private CommonStats primary = null;

    public IndexStats(String index, String uuid, ShardStats[] shards) {
        this.index = index;
        this.uuid = uuid;
        this.shards = shards;
    }

    public String getIndex() {
        return this.index;
    }

    public String getUuid() {
        return this.uuid;
    }

    public ShardStats[] getShards() {
        return this.shards;
    }

    public Map<Integer, IndexShardStats> getIndexShards() {
        if (this.indexShards != null) {
            return this.indexShards;
        }
        HashMap<Integer, ArrayList<ShardStats>> tmpIndexShards = new HashMap<Integer, ArrayList<ShardStats>>();
        for (ShardStats shard : this.shards) {
            ArrayList<ShardStats> lst = (ArrayList<ShardStats>)tmpIndexShards.get(shard.getShardRouting().id());
            if (lst == null) {
                lst = new ArrayList<ShardStats>();
                tmpIndexShards.put(shard.getShardRouting().id(), lst);
            }
            lst.add(shard);
        }
        this.indexShards = new HashMap<Integer, IndexShardStats>();
        for (Map.Entry entry : tmpIndexShards.entrySet()) {
            this.indexShards.put((Integer)entry.getKey(), new IndexShardStats(((ShardStats)((List)entry.getValue()).get(0)).getShardRouting().shardId(), ((List)entry.getValue()).toArray(new ShardStats[((List)entry.getValue()).size()])));
        }
        return this.indexShards;
    }

    @Override
    public Iterator<IndexShardStats> iterator() {
        return this.getIndexShards().values().iterator();
    }

    public CommonStats getTotal() {
        if (this.total != null) {
            return this.total;
        }
        CommonStats stats = new CommonStats();
        for (ShardStats shard : this.shards) {
            stats.add(shard.getStats());
        }
        this.total = stats;
        return stats;
    }

    public CommonStats getPrimaries() {
        if (this.primary != null) {
            return this.primary;
        }
        CommonStats stats = new CommonStats();
        for (ShardStats shard : this.shards) {
            if (!shard.getShardRouting().primary()) continue;
            stats.add(shard.getStats());
        }
        this.primary = stats;
        return stats;
    }

    public static class IndexStatsBuilder {
        private final String indexName;
        private final String uuid;
        private final List<ShardStats> shards = new ArrayList<ShardStats>();

        public IndexStatsBuilder(String indexName, String uuid) {
            this.indexName = indexName;
            this.uuid = uuid;
        }

        public IndexStatsBuilder add(ShardStats shardStats) {
            this.shards.add(shardStats);
            return this;
        }

        public IndexStats build() {
            return new IndexStats(this.indexName, this.uuid, this.shards.toArray(new ShardStats[this.shards.size()]));
        }
    }
}

