/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.admin.indices.refresh;

import java.io.IOException;
import org.easysearch.action.ActionListener;
import org.easysearch.action.support.ActionFilters;
import org.easysearch.action.support.replication.BasicReplicationRequest;
import org.easysearch.action.support.replication.ReplicationResponse;
import org.easysearch.action.support.replication.TransportReplicationAction;
import org.easysearch.cluster.action.shard.ShardStateAction;
import org.easysearch.cluster.service.ClusterService;
import org.easysearch.common.inject.Inject;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.settings.Settings;
import org.easysearch.index.shard.IndexShard;
import org.easysearch.indices.IndicesService;
import org.easysearch.threadpool.ThreadPool;
import org.easysearch.transport.TransportService;

public class TransportShardRefreshAction
extends TransportReplicationAction<BasicReplicationRequest, BasicReplicationRequest, ReplicationResponse> {
    public static final String NAME = "indices:admin/refresh[s]";

    @Inject
    public TransportShardRefreshAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, ActionFilters actionFilters) {
        super(settings, NAME, transportService, clusterService, indicesService, threadPool, shardStateAction, actionFilters, BasicReplicationRequest::new, BasicReplicationRequest::new, "refresh");
    }

    @Override
    protected ReplicationResponse newResponseInstance(StreamInput in) throws IOException {
        return new ReplicationResponse(in);
    }

    @Override
    protected void shardOperationOnPrimary(BasicReplicationRequest shardRequest, IndexShard primary, ActionListener<TransportReplicationAction.PrimaryResult<BasicReplicationRequest, ReplicationResponse>> listener) {
        ActionListener.completeWith(listener, () -> {
            primary.refresh("api");
            this.logger.trace("{} refresh request executed on primary", (Object)primary.shardId());
            return new TransportReplicationAction.PrimaryResult<BasicReplicationRequest, ReplicationResponse>(shardRequest, new ReplicationResponse());
        });
    }

    @Override
    protected void shardOperationOnReplica(BasicReplicationRequest request, IndexShard replica, ActionListener<TransportReplicationAction.ReplicaResult> listener) {
        ActionListener.completeWith(listener, () -> {
            replica.refresh("api");
            this.logger.trace("{} refresh request executed on replica", (Object)replica.shardId());
            return new TransportReplicationAction.ReplicaResult();
        });
    }
}

