/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.admin.indices.alias.get;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.easysearch.action.ActionListener;
import org.easysearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.easysearch.action.admin.indices.alias.get.GetAliasesResponse;
import org.easysearch.action.support.ActionFilters;
import org.easysearch.action.support.master.TransportMasterNodeReadAction;
import org.easysearch.cluster.ClusterState;
import org.easysearch.cluster.block.ClusterBlockException;
import org.easysearch.cluster.block.ClusterBlockLevel;
import org.easysearch.cluster.metadata.AliasMetadata;
import org.easysearch.cluster.metadata.IndexMetadata;
import org.easysearch.cluster.metadata.IndexNameExpressionResolver;
import org.easysearch.cluster.service.ClusterService;
import org.easysearch.common.collect.ImmutableOpenMap;
import org.easysearch.common.inject.Inject;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.logging.DeprecationLogger;
import org.easysearch.common.util.concurrent.ThreadContext;
import org.easysearch.indices.SystemIndices;
import org.easysearch.threadpool.ThreadPool;
import org.easysearch.transport.TransportService;

public class TransportGetAliasesAction
extends TransportMasterNodeReadAction<GetAliasesRequest, GetAliasesResponse> {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(TransportGetAliasesAction.class);
    private final SystemIndices systemIndices;

    @Inject
    public TransportGetAliasesAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, SystemIndices systemIndices) {
        super("indices:admin/aliases/get", transportService, clusterService, threadPool, actionFilters, GetAliasesRequest::new, indexNameExpressionResolver);
        this.systemIndices = systemIndices;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected ClusterBlockException checkBlock(GetAliasesRequest request, ClusterState state) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, this.indexNameExpressionResolver.concreteIndexNamesWithSystemIndexAccess(state, request));
    }

    @Override
    protected GetAliasesResponse read(StreamInput in) throws IOException {
        return new GetAliasesResponse(in);
    }

    @Override
    protected void masterOperation(GetAliasesRequest request, ClusterState state, ActionListener<GetAliasesResponse> listener) {
        String[] concreteIndices;
        try (ThreadContext.StoredContext ignore = this.threadPool.getThreadContext().newStoredContext(false);){
            concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(state, request);
        }
        boolean systemIndexAccessAllowed = this.indexNameExpressionResolver.isSystemIndexAccessAllowed();
        ImmutableOpenMap<String, List<AliasMetadata>> aliases = state.metadata().findAliases(request, concreteIndices);
        listener.onResponse(new GetAliasesResponse(TransportGetAliasesAction.postProcess(request, concreteIndices, aliases, state, systemIndexAccessAllowed, this.systemIndices)));
    }

    static ImmutableOpenMap<String, List<AliasMetadata>> postProcess(GetAliasesRequest request, String[] concreteIndices, ImmutableOpenMap<String, List<AliasMetadata>> aliases, ClusterState state, boolean systemIndexAccessAllowed, SystemIndices systemIndices) {
        boolean noAliasesSpecified = request.getOriginalAliases() == null || request.getOriginalAliases().length == 0;
        ImmutableOpenMap.Builder<String, List<AliasMetadata>> mapBuilder = ImmutableOpenMap.builder(aliases);
        for (String index : concreteIndices) {
            if (aliases.get(index) != null || !noAliasesSpecified) continue;
            List previous = mapBuilder.put(index, Collections.emptyList());
            assert (previous == null);
        }
        ImmutableOpenMap<String, List<AliasMetadata>> finalResponse = mapBuilder.build();
        return finalResponse;
    }

    private static void checkSystemIndexAccess(GetAliasesRequest request, SystemIndices systemIndices, ClusterState state, ImmutableOpenMap<String, List<AliasMetadata>> aliasesMap) {
        ArrayList<String> systemIndicesNames = new ArrayList<String>();
        Iterator<String> it = aliasesMap.keysIt();
        while (it.hasNext()) {
            String indexName = it.next();
            IndexMetadata index = state.metadata().index(indexName);
            if (index == null || !index.isSystem()) continue;
            systemIndicesNames.add(indexName);
        }
        if (!systemIndicesNames.isEmpty()) {
            deprecationLogger.deprecate("open_system_index_access", "this request accesses system indices: {}, but in a future major version, direct access to system indices will be prevented by default", systemIndicesNames);
        } else {
            TransportGetAliasesAction.checkSystemAliasAccess(request, systemIndices);
        }
    }

    private static void checkSystemAliasAccess(GetAliasesRequest request, SystemIndices systemIndices) {
        List systemAliases = Arrays.stream(request.aliases()).filter(alias -> systemIndices.isSystemIndex((String)alias)).collect(Collectors.toList());
        if (!systemAliases.isEmpty()) {
            deprecationLogger.deprecate("open_system_alias_access", "this request accesses aliases with names reserved for system indices: {}, but in a future major version, directaccess to system indices and their aliases will not be allowed", systemAliases);
        }
    }
}

